# WindowJS
jQuery plugin to create a new window with CSS3 transitions.


## How to Use?

WindowJS depends on jQuery. Include them both in your HTML code:

```html
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.2/animate.min.css">
<link rel="stylesheet" href="windowJS.min.css">
<script src="jquery.js" type="text/javascript"></script>
<script src="windowJS.min.js" type="text/javascript"></script>
```
You must alter your HTML code.

```html
<div class="windowjs" style="display:none">
    <div class="windowjs-content"></div>
</div>
```

then in your code do:

```js
$('.windowjs').windowJS();
```



Options
-------------------------

| Option        | Description           | Type           | Default  |
| ------------- |:-------------:| -----:|-----:|
| close     | Trigger to close | string | [data-dismiss="windowjs"]  |
| trigger   | Trigger to open |   string | [data-toggle="windowjs"] |
| position | position       | string | fixed |
| width | Width of the window  | string | 100% |
| height | Height of the window  | string | 100% |
| viewport     | The window resize when browser resize | boolean | false |
| top     | Top position | string | 0px |
| left | Left position | string | 0px |
| zIndexIn     | Zindex in | string | 9999 |
| zIndexOut     | Zindex out | string | -9999 |
| backgroundColor     | Define background color | string | #4aa3df |
| opacityIn     | Opacity when the window goes in | string | 1 |
| opacityOut     | Transition when the window goes out | string | 0 |
| animatedIn     | Opacity when the window goes in  | string | zoomIn |
| animatedOut     | Transition when the window goes out | string | zoomOut |
| animationDuration     | Animation duration | string | .5s |
| overflow     | This makes your window scrollable or not | string | auto |

Callbacks
-------------------------

| Option        | Description   |
| ------------- |:-------------:|
| beforeOpen     | Action before window open |
| afterOpen   | Action after window open |
| beforeClose | Action before window close |
| afterClose | Action after window close  |

# Methods

## Open window
```js
$('.windowjs').data('windowjs').open();
```

## Folder Structure
```
windowjs/
├── dist/
│   ├── windowjs.js      <-- Will always be the latest stable version
│   ├── windowjs.min.js  <-- Latest minified stable version
│   ├── windowjs.css     <-- Will always be the latest stable version
│   ├── windowjs.min.css <-- Latest minified stable version
├── .gitignore
├── LICENSE
└── README.md
```

## Bugs and Feature Requests
For comments, bugs or feature requests you can open an issue at [New Issue](https://github.com/robanquieri/windowjs/issues/new).



## Copyright and License
Code is released under [the MIT license](https://github.com/robanquieri/windowjs/blob/master/LICENSE) © Rogério Banquieri