/*!
 * jQuery WindowJS plugin
 * Version 1.2
 * Requires jQuery
 *
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 * Copyright (c) 2015 Rogério Banquieri - rogerio@banquieri.com
 *
 */
(function($) {

    $.windowJS = function( element, options ) {

        var defaults = {
            close: '[data-dismiss="windowjs"]',
            trigger: '[data-toggle="windowjs"]',
            position:'fixed',
            width:'100%',
            height:'100%',
            viewport: false,
            top:'0px',
            left:'0px',
            zIndexIn: '9999',
            zIndexOut: '-9999',
            backgroundColor: '#4aa3df',
            opacityIn:'1',
            opacityOut:'0',
            animatedIn:'zoomIn',
            animatedOut:'zoomOut',
            animationDuration:'.5s',
            overflow:'auto',
            beforeOpen: function() {},
            afterOpen: function() {},
            beforeClose: function() {},
            afterClose: function() {}
        };

        var plugin = this;

        plugin.settings = {}

        var $element = $( element );

        plugin.init = function() {

            plugin.settings = $.extend( {}, defaults, options );

            var stylesInit = {
                'display': 'block',
                'position': plugin.settings.position,
                'width': plugin.settings.width,
                'height': plugin.settings.height,
                'top': plugin.settings.top,
                'left': plugin.settings.left,
                'background-color': plugin.settings.backgroundColor,
                'overflow-y': plugin.settings.overflow,
                'z-index': plugin.settings.zIndexOut,
                'opacity': plugin.settings.opacityOut,
                '-webkit-animation-duration': plugin.settings.animationDuration,
                '-moz-animation-duration': plugin.settings.animationDuration,
                '-ms-animation-duration': plugin.settings.animationDuration,
                'animation-duration': plugin.settings.animationDuration
            };

            $element.css( stylesInit );

            if( plugin.settings.viewport ){
                resize();
                $( window ).resize( resize );
            }

            $( document ).on( 'click', plugin.settings.trigger, function( event ){
                event.preventDefault();
                start();
            });

            $element.find( plugin.settings.close ).bind( 'click', function( event )
            {
                event.preventDefault();

                if( plugin.settings.viewport )
                {
                    $( 'body' ).removeAttr( 'style' );
                }

                plugin.settings.beforeClose();
                $element.removeClass( 'animated ' + plugin.settings.animatedIn ).addClass( 'animated ' + plugin.settings.animatedOut );
                $element.one( 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', afterClose );
            });

            function start(){
                var stylesOnLoad = {
                    'opacity': plugin.settings.opacityIn,
                    'z-index': plugin.settings.zIndexIn
                };

                if( plugin.settings.viewport )
                {
                    $( 'body' ).css( 'overflow', 'hidden' );
                }

                plugin.settings.beforeOpen();
                $element.css( stylesOnLoad );
                $element.removeClass( 'animated ' + plugin.settings.animatedOut ).addClass( 'animated ' + plugin.settings.animatedIn );
                $element.one( 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', afterOpen );
            }

            function resize(){
                $element.css( 'height', $( window ).height() );
            }

            function afterClose(){
                var stylesOnClose = {
                    'opacity': plugin.settings.opacityOut,
                    'z-index': plugin.settings.zIndexOut
                };

                $element.css( stylesOnClose );
                plugin.settings.afterClose();
            }

            function afterOpen()
            {
                plugin.settings.afterOpen();
            }
        }

        plugin.open = function() {
            var stylesOnLoad = {
                'opacity': plugin.settings.opacityIn,
                'z-index': plugin.settings.zIndexIn
            };

            if( plugin.settings.viewport )
            {
                $( 'body' ).css( 'overflow', 'hidden' );
            }

            plugin.settings.beforeOpen();
            $element.css( stylesOnLoad );
            $element.removeClass( 'animated ' + plugin.settings.animatedOut ).addClass( 'animated ' + plugin.settings.animatedIn );
            $element.one( 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', plugin.settings.afterOpen );
        }

        plugin.init();
    }

    $.fn.windowJS = function( options ){
        return this.each( function() {
            if ( undefined == $( this ).data( 'windowjs' ) ) {
                var plugin = new $.windowJS( this, options );
                $( this ).data( 'windowjs', plugin );
            }
        });
    }

})(jQuery);