# simpleSlides

This simple jQuery plug in places images in a clickable image slider.

# Example JS

```JavaScript
$('.someDivs').simpleSlides({
// pass in options

width: 420, // width of gallery // default: 500
height: 300, // height of gallery // default: 370
fadeDuration: 330, // fade duration when stepping to next photo // default: 550
captionDivHeight: 35, // height of div containing photo caption and directional arrows // default: 35
iconSize: 25, // size of SVG arrow icons // default: 25

});
```
# Example HTML
All that you need to do here is place the images directly inside a container. Here, each member of the "someDivs" class will become an individual gallery. You can add a caption to each image by placing a "data-caption" attribute value on the image.
```html
<div class="someDivs">
    <img src="#1.jpeg" alt="demo-image" data-caption="Caption of the first image"></img>
    <img src="#2.jpeg" alt="demo-image" data-caption="Caption of the second image"></img>
    <img src="#3.jpeg" alt="demo-image" data-caption="Caption of the third image"></img>
</div>
<div class="someDivs">
    <img src="#4.jpeg" alt="demo-image" data-caption="Caption of the first image"></img>
    <img src="#5.jpeg" alt="demo-image" data-caption="Caption of the second image"></img>
    <img src="#6.jpeg" alt="demo-image" data-caption="Caption of the third image"></img>
</div>
```
