(function($, window, document) {
  'use strict';
  $.fn.simpleSlides = function(options) {

    var settings = $.extend({

      // defaults //
      captionDivHeight: 35,
      iconSize: 25,
      width: 500,
      height: 370,
      fadeDuration: 550

    }, options);

    return this.each(function() {
      var buttonCenter = (settings.captionDivHeight - settings.iconSize) / 2;
      var focusedGallery = false;

      var directions = {
        forward: "forward",
        backward: "backward"
      };

      // Label active images //
      $(this).addClass('gallery');
      $('.gallery img:first-child').addClass('activeImage').css('z-index', 3);

      // Size the gallery //
      $('.gallery').css({
        "width": settings.width,
        "height": settings.height,
        "position": "relative"
      });

      // Add class and style to images //
      $('.gallery').children().addClass('galleryImage').css({
        "position": "absolute",
        "width": "100%",
        "height": "100%"
      });

      // Lay caption div on top of gallery //
      $('.gallery').append("<div class='captionDiv'></div>");
      changeCaptions();

      // Style title div //
      $('.captionDiv').css({
        "width": "100%",
        "position": "absolute",
        "bottom": "0",
        "z-index": "4",
        "height": settings.captionDivHeight,
      });

      // Button constructor //
      function createArrowIcons(src, size, tag) {
        var img = document.createElement("img");
        img.src = src;
        img.width = size;
        img.height = size;
        img.className = tag;
        img.style.zIndex = 5;

        $('.captionDiv').append(img);
      }
      createArrowIcons("icons/1443333697_arrow-right-01.svg", settings.iconSize, "rightArrow");
      createArrowIcons("icons/1443333689_arrow-left-01.svg", settings.iconSize, "leftArrow");

      // Place arrow icons
      var rightArrow = $('.rightArrow');
      var leftArrow = $('.leftArrow');
      rightArrow.css({
        "top": buttonCenter // Remove these lines if you do not want the arrow icons vertically centered //
      });
      leftArrow.css({
        "top": buttonCenter // Remove these lines if you do not want the arrow icons vertically centered //
      });

      // Identify focused gallery - replace previously focused gallery - step to next image //
      rightArrow.on('click', function() {
        $(focusedGallery).removeClass('currentGallery');
        $(this).closest('.gallery').addClass('currentGallery');
        focusedGallery = $(this).closest('.gallery');
        stepGallery(directions.forward);
      });
      leftArrow.on('click', function() {
        $(focusedGallery).removeClass('currentGallery');
        $(this).closest('.gallery').addClass('currentGallery');
        focusedGallery = $(this).closest('.gallery');
        stepGallery(directions.backward);
      });

      // change photos forwards and backwards //
      function stepGallery(direction) {
        var active = $('.currentGallery .activeImage');
        var step;

        if (direction === directions.backward) {
          step = (active.prev('.galleryImage').length > 0) ? active.prev('.galleryImage') : $('.currentGallery .galleryImage:last');
        } else {
          step = (active.next('.galleryImage').length > 0) ? active.next('.galleryImage') : $('.currentGallery .galleryImage:first');
        }

        step.css('z-index', 2);
        active.fadeOut(settings.fadeDuration, function() {
          active.css('z-index', 1).show().removeClass('activeImage');
          step.css('z-index', 3).addClass('activeImage');
          changeCaptions();
        });
      }

      // change captions //
      function changeCaptions() {
        $('.captionDiv').each(function() {
          var correspondingActiveImage = $(this).siblings('.activeImage');
          var correspondingCaption = $(correspondingActiveImage).data('caption'); 

          $('.currentGallery .captionDiv p').remove();

          $(this).append("<p class='caption'></p>");
          $(this).children('.caption').append(correspondingCaption);
        });
      }
    });
  };
}(jQuery, window, document));