# EZ Modal
Manage bootstrap modal easily (jQuery needed)


## Getting Started

This script :
* Generate a modal with params
* Delete him from DOM after closed
    

### USAGE

First, you need Boostrap 4 and jQuery

Then, import EZModal

```js
<script src="EZModal.js"></script>
```

EZ use !

```js
new EZModal('mymodal').setTitle('h5', 'Awesome title').setElement('body', '<p> Body is here !</p>')
```

Constructor :

- `modal_id`(string) - set the id of the modal, you can use random name
- `dismissable`(boolean)(optionnal) - set if modal can be close. Default: true


Methods : 

- `setTitle(tag, text)` - Set title to your modal
  * `tag(string)` - HTML tag for title (h1, h2, p ...)
  * `text(string)` - Title text
  
- `setElement(type, el)` - Set content in your modal
  * `type(string)` - Can only be "header", "footer", "body"
  * `el(string)` - HTML of your element
  
- `show()` - Show your modal

- `onClose(callback)` - Execute function when modal closes
  * `callback(function)` - Callback function
  
- `on(event, callback)` - More globally, attach an event listener (see [Bootstrap modal events](https://getbootstrap.com/docs/4.0/components/modal/#events))
  * `event(string)` - Event name
  * `callback(function)` - Callback function


DEMO

```html
<button id="btn" type="submit">OK</button>
```
```js
const btn = document.getElementById('btn');
const modal = new EZModal('mymodal')
    .setTitle('h5', 'Awesome title')
    .setElement('body', '<p> Body is here !</p>')
    .setElement('footer', '<button>Close</button>');
        
btn.addEventListener('click', function (e) {
    modal.show();
})
```


ENJOY


## Authors

* **RockDaFox**

See also the list of [contributors](https://github.com/your/project/contributors) who participated in this project.

## License

This project is licensed under the MIT License - see the [LICENSE.md](LICENSE.md) file for details

