/**
 * jQuery UI Rotatable Widget
 *
 * @author Abdullah Pazarbasi (https://github.com/abdullahpazarbasi/jquery-ui-rotatable)
 * @license MIT
 *
 * Features:
 * Supports CSS 2D transform (only 2D)
 * Rotation by mouse wheel
 * Rotation with/without handle
 * Compatible with other jQuery UI widgets included Draggable and Resizable
 * Compatible with Dave Furfero's jQuery UI Touch Punch
 * All angles in degrees
 * AlsoRotate extension
 *
 * Usages:
 * $('#foo .bar').rotatable();
 * $('#foo .bar').resizable().rotatable().draggable();
 * $('#foo .bar').rotatable({ angle: 30 });
 *
 * Inspired by jQuery UI Resizable Widget and Aidan Rogers's (godswearhats) jquery-ui-rotatable Widget
 * Thanks to jQuery UI Development Team (https://jqueryui.com/about/)
 * Thanks to Aidan Rogers (https://github.com/godswearhats/jquery-ui-rotatable)
 */
!function(t){"function"==typeof define&&define.amd?define(["jquery"],t):t(jQuery)}(function(t){t.widget("ui.rotatable",t.ui.mouse,{widgetEventPrefix:"rotate",options:{classes:{},create:null,distance:1,delay:0,disabled:!1,alsoRotate:!1,angle:0,handle:!0,handleElementSelector:"<div></div>",rotationOriginPosition:{top:null,left:null},snap:!1,snapStep:22.5,rotate:function(t,e){},start:function(t,e){},stop:function(t,e){},wheel:!0,wheelStep:7.5},plugins:{},handlers:{},elementStartAngle:0,elementCurrentAngle:0,elementStopAngle:0,mouseStartAngle:0,isRotating:!1,hasRotated:!1,_num:function(t){return parseFloat(t)||0},_isNumber:function(t){return!isNaN(parseFloat(t))},_round:function(t,e){var n=this._num(t),i=Math.pow(10,e),o=n*i;return Math.round(o)/i},_mod:function(t,e){return(t%e+e)%e},_canBeParent:function(){return!this.element[0].nodeName.match(/^(canvas|textarea|input|select|button|img)$/i)},_enableSelection:function(t){return t.attr("unselectable","off"),t.css("user-select","auto"),t.off(".ui-disableSelection")},_disableSelection:function(t){t.attr("unselectable","on"),t.css("user-select","none");var e="onselectstart"in document.createElement("div")?"selectstart":"mousedown";return t.on(e+".ui-disableSelection",function(t){t.preventDefault()})},_angleInDegrees:function(t){return 180*t/Math.PI},_calculateSnap:function(t){return Math.round(t/this.options.snapStep)*this.options.snapStep},_getElementOffset:function(){this._do(0);var t=this.element.offset();return this._do(this.elementCurrentAngle),t},_isRotationOriginPositionGiven:function(){return"number"==typeof this.options.rotationOriginPosition.top||"number"==typeof this.options.rotationOriginPosition.left},_getRotationOriginPositionTop:function(){return"number"==typeof this.options.rotationOriginPosition.top?this.options.rotationOriginPosition.top:Math.round(this.element.height()/2)},_getRotationOriginPositionLeft:function(){return"number"==typeof this.options.rotationOriginPosition.left?this.options.rotationOriginPosition.left:Math.round(this.element.width()/2)},_calculateOrigin:function(){var t=this._getElementOffset();if(this._isRotationOriginPositionGiven())return{x:t.left+this._getRotationOriginPositionLeft(),y:t.top+this._getRotationOriginPositionTop()};var e=this.element.css("transform-origin");if("string"==typeof e){var n=e.match(/([\d.]+)px +([\d.]+)px/);if(null!==n)return{x:t.left+this._num(n[1]),y:t.top+this._num(n[2])}}return{x:t.left+Math.round(this.element.width()/2),y:t.top+Math.round(this.element.height()/2)}},_calculateRotationAngleViaMousePosition:function(t){var e=this._calculateOrigin(),n=t.pageX-e.x,i=t.pageY-e.y,o=this._angleInDegrees(Math.atan2(i,n))-this.mouseStartAngle+this.elementStartAngle;return(this.options.snap||t.shiftKey)&&(o=this._calculateSnap(o)),this._mod(o,360)},_do:function(t){var e=this.element,n=e.css("transform");if(void 0!==n){this._isRotationOriginPositionGiven()&&e.css("transform-origin",this._getRotationOriginPositionLeft()+"px "+this._getRotationOriginPositionTop()+"px");var i="rotate("+t+"deg) ";if("none"!==n){var o=/matrix\((.*),(.*),(.*),(.*),(.*),(.*)\)/.exec(n);if(null!==o){var s=this._num(o[1]),a=this._num(o[2]),r=this._num(o[3]),l=this._num(o[4]),h=this._num(o[5]),u=this._num(o[6]);0!==h&&(i+=0===u?"translate("+h+"px) ":"translate("+h+"px, "+u+"px) ");var g=s*l-a*r,c=null,d=null;if(0!==s||0!==a){var f=this._round(Math.sqrt(s*s+a*a),5);this._angleInDegrees(a>0?Math.acos(s/f):-Math.acos(s/f)),c=f,d=this._round(g/f,5),1===c&&1===d||(i+="scale("+c+(c===d?"":", "+d)+") "),0!==(c=Math.atan((s*r+a*l)/(f*f)))&&(i+="skewX("+this._angleInDegrees(c)+"deg) ")}else if(0!==r||0!==l){var m=Math.sqrt(r*r+l*l);this._angleInDegrees(Math.PI/2-(l>0?Math.acos(-r/m):-Math.acos(r/m))),d=m,1===(c=g/m)&&1===d||(i+="scale("+c+(c===d?"":", "+d)+") "),0!==(c=Math.atan((s*r+a*l)/(m*m)))&&(i+="skewY("+this._angleInDegrees(c)+"deg) ")}else i+="scale(0) "}}e.css("transform",i)}},_create:function(){var e=this.options;this.element.addClass("ui-rotatable"),e.handle&&this._placeHandle(),this.handlers={_mouseWheel:t.proxy(this._mouseWheel,this)},e.wheel&&this.element.bind("wheel",this.handlers._mouseWheel),this.rotationOriginPosition(e.rotationOriginPosition),this.elementCurrentAngle=this._mod(this.options.angle||0,360),this._do(this.elementCurrentAngle),this._mouseInit()},_destroy:function(){this._mouseDestroy(),this.element.removeClass("ui-rotatable"),this.element.off("rotatable"),this.element.find(".ui-rotatable-handle:first").remove(),this.options.wheel&&this.element.unbind("wheel",this.handlers._mouseWheel)},_placeHandle:function(){var e=this.options;if(this.element&&this._canBeParent()){var n=this.element.find(".ui-rotatable-handle:first");n.length<1&&((n=t(e.handleElementSelector)).addClass("ui-rotatable-handle"),n.appendTo(this.element),this._disableSelection(n)),"absolute"!==n.css("position")&&n.css("position","absolute"),n.width()<1&&n.width(9),n.height()<1&&n.height(9),"auto"===n.css("cursor")&&n.css("cursor","grab")}},_getJqHandle:function(){return this.options.handle?this.element.find(".ui-rotatable-handle:first"):this.element},_propagate:function(e,n){t.ui.plugin.call(this,e,[n,this.ui()]),"rotate"!==e&&this._trigger(e,n,this.ui())},_setOption:function(t,e){this._super(t,e)},_mouseCapture:function(t){var e=this.options;if(!this.element||this.element.disabled||e.disabled)return!1;if(e.handle){var n=this._getJqHandle();if(t.target!==n[0])return!1}else if(t.target!==this.element[0])return!1;return!0},_mouseStart:function(t){var e=this._getJqHandle(),n=this._calculateOrigin(),i=t.pageX-n.x,o=t.pageY-n.y;return this.mouseStartAngle=this._angleInDegrees(Math.atan2(o,i)),this.elementStartAngle=this.elementCurrentAngle,this.isRotating=!0,this.hasRotated=!1,this.element.addClass("ui-rotatable-rotating"),e.length>0&&"grab"===e.css("cursor")&&e.css("cursor","grabbing"),this._propagate("start",t),!0},_mouseDrag:function(t){if(!this.element||this.element.disabled||this.options.disabled)return!1;var e=this._calculateRotationAngleViaMousePosition(t),n=this.elementCurrentAngle;if(this.elementCurrentAngle=e,!1===this._propagate("rotate",t))return this.elementCurrentAngle=n,!1;var i=this.ui();return!1===this._trigger("rotate",t,i)?(this.elementCurrentAngle=n,!1):(i.angle.current!==e&&(e=i.angle.current,this.elementCurrentAngle=e),this._do(e),n!==e&&(this.hasRotated=!0),!1)},_mouseStop:function(t){if(!this.element)return!1;var e=this._getJqHandle();return this.isRotating=!1,this.elementStopAngle=this.elementCurrentAngle,this.element.removeClass("ui-rotatable-rotating"),e.length>0&&"grabbing"===e.css("cursor")&&e.css("cursor","grab"),this._propagate("stop",t),!1},_mouseWheel:function(t){if(!this.element||this.element.disabled||this.options.disabled)return!1;var e=Math.round(t.originalEvent.deltaY*this._num(this.options.wheelStep));return(this.options.snap||t.shiftKey)&&(e=this._calculateSnap(e)),e=this.elementCurrentAngle+e,this.angle(e),this._trigger("rotate",t,this.ui()),!0},angle:function(t){var e=this.options;if(void 0===t)return e.angle;e.angle=t,this.elementCurrentAngle=this._mod(t,360),this._do(e.angle)},handle:function(t){var e=this.options;if(void 0===t)return e.handle;e.handle=t,e.handle&&this._placeHandle()},handleElementSelector:function(t){var e=this.options;if(void 0===t)return e.handleElementSelector;e.handleElementSelector=t,e.handle&&this._placeHandle()},rotationOriginPosition:function(t){var e=this.options;if(void 0===t)return e.rotationOriginPosition;"number"==typeof t.top&&(e.rotationOriginPosition.top=t.top),"number"==typeof t.left&&(e.rotationOriginPosition.left=t.left)},ui:function(){return{element:this.element,angle:{start:this.elementStartAngle,current:this.elementCurrentAngle,stop:this.elementStopAngle}}}}),t.ui.plugin.add("rotatable","alsoRotate",{start:function(){var e=t(this).rotatable("instance").options;t(e.alsoRotate).each(function(){t(this).data("ui-rotatable-alsorotate",{})})},rotate:function(e,n){var i=t(this).rotatable("instance").options;console.log(JSON.stringify(i,null,2)),t(i.alsoRotate).each(function(){t(this).data("ui-rotatable-alsorotate")})},stop:function(){t(this).removeData("ui-rotatable-alsorotate")}});t.ui.rotatable;return t.ui.rotatable});
