/*!
 * jQuery ClassyLightbox
 * www.class.pm
 *
 * Written by Marius Stanciu - Sergiu <marius@class.pm>
 * Licensed under the MIT license www.class.pm/LICENSE-MIT
 * Version 1.2.0
 *
 */

(function($, win, doc) {
    var mobile = false, isMobile = (function(str) {
        return function() {
            return str.search(arguments[0]);
        };
    })((navigator && navigator.userAgent) ? navigator.userAgent.toLowerCase() : '');
    if (isMobile('mobile') > -1) {
        if (isMobile('android') > -1 || D('googletv') > -1 || D('htc_flyer') > -1) {
            mobile = true;
        }
    }
    if (isMobile('opera') > -1) {
        if (D('mini') > -1 && D('mobi') > -1) {
            mobile = true;
        }
    }
    if (isMobile('iphone') > -1) {
        mobile = true;
    }
    if (isMobile('windows phone os 7') > -1) {
        mobile = true;
    }
    $.extend($.easing, {
        easeOutBackMin: function(x, t, b, c, d, s) {
            s = 1;
            return c * ((t = t / d - 1) * t * ((s + 1) * t + s) + 1) + b;
        }
    });
    $.extend({
        ClassyLightbox: {
            defaults: {
                style: {
                    zIndex: 99999,
                    width: 470,
                    height: 280
                },
                modal: false,
                overlay: {
                    opacity: 0.6
                },
                animation: {
                    show: {
                        duration: 400,
                        easing: 'easeOutBackMin'
                    },
                    close: {
                        duration: 200,
                        easing: 'easeOutBackMin'
                    },
                    move: {
                        duration: 700,
                        easing: 'easeOutBackMin'
                    },
                    shake: {
                        duration: 100,
                        easing: 'easeOutBackMin',
                        distance: 10,
                        loops: 2
                    }
                },
                flash: {
                    width: 640,
                    height: 360
                },
                iframe: {
                    width: 640,
                    height: 360
                },
                maxSize: {
                    width: -1,
                    height: -1
                },
                preload: true,
                from: 'top',
                ajax: {
                    type: 'GET',
                    cache: false,
                    dataType: 'html'
                }
            },
            options: {
            },
            animations: {
            },
            gallery: {
            },
            image: {
            },
            template: {
                lightbox: [],
                buttons: {
                    close: [],
                    prev: [],
                    max: [],
                    next: []
                },
                background: [],
                image: [],
                title: [],
                html: []
            },
            visible: false,
            maximized: false,
            mode: 'image',
            videoregs: {
                swf: {
                    reg: /[^\.]\.(swf)\s*$/i
                },
                youtu: {
                    reg: /youtu\.be\//i,
                    split: '/',
                    index: 3,
                    iframe: 1,
                    url: "http://www.youtube.com/embed/%id%?autoplay=1&amp;fs=1&amp;rel=0&amp;enablejsapi=1"
                },
                youtube: {
                    reg: /youtube\.com\/watch/i,
                    split: '=',
                    index: 1,
                    iframe: 1,
                    url: "http://www.youtube.com/embed/%id%?autoplay=1&amp;fs=1&amp;rel=0&amp;enablejsapi=1"
                },
                vimeo: {
                    reg: /vimeo\.com/i,
                    split: '/',
                    index: 3,
                    iframe: 1,
                    url: "http://player.vimeo.com/video/%id%?hd=1&amp;autoplay=1&amp;show_title=1&amp;show_byline=1&amp;show_portrait=0&amp;color=&amp;fullscreen=1"
                },
                metacafe: {
                    reg: /metacafe\.com\/watch/i,
                    split: '/',
                    index: 4,
                    url: "http://www.metacafe.com/fplayer/%id%/.swf?playerVars=autoPlay=yes"
                },
                dailymotion: {
                    reg: /dailymotion\.com\/video/i,
                    split: '/',
                    index: 4,
                    iframe: true,
                    url: "http://www.dailymotion.com/embed/video/%id%?autoPlay=1&forcedQuality=hd720"
                },
                ustream: {
                    reg: /ustream\.tv/i,
                    split: '/',
                    index: 4,
                    url: "http://www.ustream.tv/flash/video/%id%?loc=%2F&amp;autoplay=true&amp;vid=%id%&amp;disabledComment=true&amp;beginPercent=0.5331&amp;endPercent=0.6292&amp;locale=en_US"
                },
                twitvid: {
                    reg: /twitvid\.com/i,
                    split: '/',
                    index: 3,
                    url: "http://www.twitvid.com/player/%id%"
                },
                wordpress: {
                    reg: /v\.wordpress\.com/i,
                    split: '/',
                    index: 3,
                    url: "http://s0.videopress.com/player.swf?guid=%id%&amp;v=1.01"
                }
            },
            mapsreg: {
                bing: {
                    reg: /bing\.com\/maps/i,
                    split: '?',
                    index: 1,
                    url: "http://www.bing.com/maps/embed/?emid=3ede2bc8-227d-8fec-d84a-00b6ff19b1cb&amp;w=%width%&amp;h=%height%&amp;%id%"
                },
                streetview: {
                    reg: /maps\.google\.(com|co.uk|ca|es)(.*)layer=c/i,
                    split: '?',
                    index: 1,
                    url: "http://maps.google.com/?output=svembed&amp;%id%"
                },
                googlev2: {
                    reg: /maps\.google\.(com|co.uk|ca|es)\/maps\/ms/i,
                    split: '?',
                    index: 1,
                    url: "http://maps.google.com/maps/ms?output=embed&amp;%id%"
                },
                google: {
                    reg: /maps\.google\.(com|co.uk|ca|es)/i,
                    split: '?',
                    index: 1,
                    url: "http://maps.google.com/maps?%id%&amp;output=embed"
                }
            },
            imgsreg: /\.(?:jpg|png|jpeg|gif|bmp|tiff)/i,
            overlay: {
                _create: function(options) {
                    this.options = options;
                    this.element = $('<div id="' + new Date().getTime() + '" class="lightbox-overlay"></div>');
                    this.element.css($.extend({
                    }, {
                        position: 'fixed',
                        top: 0,
                        left: 0,
                        opacity: 0,
                        display: 'none',
                        'z-index': this.options.zIndex
                    }, this.options.style));
                    this.element.bind('click', $.proxy(function(event) {
                        if (!this.options.modal && !this.hidden) {
                            if ($.isFunction(this.options.callback)) {
                                this.options.callback();
                            } else {
                                this.hide();
                            }
                        }
                        event.preventDefault();
                    }, this));
                    this.hidden = true;
                    this._build();
                    return this;
                },
                _build: function() {
                    this.target = $(doc.body);
                    this.target.append(this.element);
                },
                _resize: function(x, y) {
                    this.element.css({
                        height: 0,
                        width: 0
                    });
                    if (this.shim) {
                        this.shim.css({
                            height: 0,
                            width: 0
                        });
                    }
                    var a = {
                        x: $(doc).width(),
                        y: $(doc).height()
                    };
                    this.element.css({
                        width: '100%',
                        height: y || a.y
                    });
                    if (this.shim) {
                        this.shim.css({
                            height: 0,
                            width: 0
                        });
                        this.shim.css({
                            position: 'absolute',
                            left: 0,
                            top: 0,
                            width: this.element.width(),
                            height: y || a.y
                        });
                    }
                    return this;
                },
                show: function(callback) {
                    if (!this.hidden) {
                        return this;
                    }
                    if (this.transition) {
                        this.transition.stop();
                    }
                    if (this.shim) {
                        this.shim.css('display', 'block');
                    }
                    this.element.css({
                        display: 'block',
                        opacity: 0
                    });
                    this._resize();
                    this.hidden = false;
                    this.transition = this.element.fadeTo(this.options.showDuration, this.options.style.opacity, $.proxy(function() {
                        if (this.options.style.opacity) {
                            this.element.css(this.options.style);
                        }
                        this.element.trigger('show');
                        if ($.isFunction(callback)) {
                            callback();
                        }
                    }, this));
                    return this;
                },
                hide: function(callback) {
                    if (this.hidden) {
                        return this;
                    }
                    if (this.transition) {
                        this.transition.stop();
                    }
                    if (this.shim) {
                        this.shim.css('display', 'none');
                    }
                    this.hidden = true;
                    this.transition = this.element.fadeTo(this.options.closeDuration, 0, $.proxy(function() {
                        this.element.trigger('hide');
                        if ($.isFunction(callback)) {
                            callback();
                        }
                        this.element.css({
                            height: 0,
                            width: 0,
                            display: 'none'
                        });
                    }, this));
                    return this;
                }
            },
            _create: function(options) {
                this.options = $.extend(true, this.defaults, options);
                var c = $('<div class="lightbox mode-image">' +
                        '<div class="border-top-left"></div>' +
                        '<div class="border-top-middle"></div>' +
                        '<div class="border-top-right"></div>' +
                        '<a class="close" href="#close">' +
                        '<span>close</span>' +
                        '</a>' +
                        '<div class="navigator">' +
                        '<a class="left" href="#">' +
                        '<span>previous</span>' +
                        '</a>' +
                        '<a class="right" href="#">' +
                        '<span>next</span>' +
                        '</a>' +
                        '</div>' +
                        '<div class="buttons">' +
                        '<div class="init"></div>' +
                        '<a class="left" href="#">' +
                        '<span>previous</span>' +
                        '</a>' +
                        '<a class="max" href="#">' +
                        '<span>maximize</span>' +
                        '</a>' +
                        '<div class="custom"></div>' +
                        '<a class="right" href="#">' +
                        '<span>next</span>' +
                        '</a>' +
                        '<div class="end"></div>' +
                        '</div>' +
                        '<div class="background"></div>' +
                        '<div class="lightbox-html"></div>' +
                        '<div class="border-bottom-left"></div>' +
                        '<div class="border-bottom-middle"></div>' +
                        '<div class="border-bottom-right"></div>' +
                        '</div>');
                var e = this.template;
                this.overlay._create({
                    style: this.options.overlay,
                    modal: this.options.modal,
                    zIndex: this.options.style.zIndex - 1,
                    callback: this.proxy(this.close),
                    showDuration: (mobile ? this.options.animation.show.duration / 2 : this.options.animation.show.duration),
                    closeDuration: (mobile ? this.options.animation.close.duration / 2 : this.options.animation.close.duration)
                });
                e.lightbox = c;
                e.navigator = $('.navigator', c);
                e.buttons.div = $('.buttons', c);
                e.buttons.close = $('.close', c);
                e.buttons.prev = $('.left', c);
                e.buttons.max = $('.max', c);
                e.buttons.next = $('.right', c);
                e.buttons.custom = $('.custom', c);
                e.background = $('.background', c);
                e.html = $('.lightbox-html', c);
                e.move = $('<div class="lightbox-move"></div>').css({
                    position: 'absolute',
                    'z-index': this.options.style.zIndex,
                    top: -999
                }).append(c);
                $('body').append(e.move);
                this.win = $(win);
                this._setupEvents();
                return c;
            },
            _setupEvents: function() {
                this.win[0].onorientationchange = function() {
                    if (this.visible) {
                        this.overlay._resize();
                        if (this.move && !this.maximized) {
                            this._move();
                        }
                    }
                };
                this.win.bind('resize', this.proxy(function() {
                    if (this.visible && !mobile) {
                        this.overlay._resize();
                        if (this.move && !this.maximized) {
                            this._move();
                        }
                    }
                }));
                this.win.bind('scroll', this.proxy(function() {
                    if (this.visible && this.move && !this.maximized && !mobile) {
                        this._move();
                    }
                }));
                $(doc).bind('keydown', this.proxy(function(e) {
                    if (this.visible) {
                        if (e.keyCode === 27 && this.options.modal === false) {
                            this.close();
                        }
                        if (this.gallery.total > 1) {
                            if (e.keyCode === 37) {
                                this.template.buttons.prev.triggerHandler('click', e);
                            }
                            if (e.keyCode === 39) {
                                this.template.buttons.next.triggerHandler('click', e);
                            }
                        }
                    }
                }));
                this.template.buttons.close.bind('click touchend', {
                    'fn': 'close'
                }, this.proxy(this.fn));
                this.template.buttons.max.bind('click touchend', {
                    'fn': '_cascade'
                }, this.proxy(this.fn));
                this.overlay.element.bind('show', this.proxy(function() {
                    $(this).triggerHandler('show');
                }));
                this.overlay.element.bind('hide', this.proxy(function() {
                    $(this).triggerHandler('close');
                }));
            },
            fn: function(e) {
                this[e.data.fn].apply(this);
                e.preventDefault();
            },
            proxy: function(a) {
                return $.proxy(a, this);
            },
            ex: function(f, g, h) {
                var j = {
                    type: '',
                    width: '',
                    height: '',
                    href: ''
                };
                $.each(f, this.proxy(function(c, d) {
                    $.each(d, this.proxy(function(i, e) {
                        if ((c === 'flash' && g.split('?')[0].match(e.reg)) || (c === 'iframe' && g.match(e.reg))) {
                            j.href = g;
                            if (e.split) {
                                var a = c === 'flash' ? g.split(e.split)[e.index].split('?')[0].split('&')[0] : g.split(e.split)[e.index];
                                j.href = e.url.replace('%id%', a).replace('%width%', h.width).replace('%height%', h.height);
                            }
                            j.type = e.iframe ? 'iframe' : c;
                            if (h.width) {
                                j.width = h.width;
                                j.height = h.height;
                            } else {
                                var b = this._calc(this.options[j.type].width, this.options[j.type].height);
                                j.width = b.width;
                                j.height = b.height;
                            }
                            return false;
                        }
                    }));
                    if (!!j.type) {
                        return false;
                    }
                }));
                return j;
            },
            _gallery: function(a, b) {
                var c = this, d = c.template.buttons.prev, f = c.template.buttons.next;
                c.gallery.total = a.length;
                if (a.length > 1) {
                    d.unbind('.lightbox');
                    f.unbind('.lightbox');
                    d.bind('click.lightbox touchend.lightbox', function(e) {
                        e.preventDefault();
                        a.unshift(a.pop());
                        c.show(a);
                    });
                    f.bind('click.lightbox touchend.lightbox', function(e) {
                        e.preventDefault();
                        a.push(a.shift());
                        c.show(a);
                    });
                    if (c.template.navigator.css('display') === 'none') {
                        c.template.buttons.div.show();
                    }
                    d.show();
                    f.show();
                    if (this.options.preload) {
                        if (a[1].href.match(this.imgsreg)) {
                            (new Image()).src = a[1].href;
                        }
                        if (a[a.length - 1].href.match(this.imgsreg)) {
                            (new Image()).src = a[a.length - 1].href;
                        }
                    }
                } else {
                    d.hide();
                    f.hide();
                }
            },
            _setupCustomButtons: function(c, d) {
                var f = this.template;
                f.buttons.custom.empty();
                $.each(c, this.proxy(function(i, a) {
                    var b = $('<a href="#" class="' + a['class'] + '">' + a['html'] + '</a>');
                    b.bind('click', this.proxy(function(e) {
                        if ($.isFunction(a.callback)) {
                            a.callback(this.template.image.src, this, d);
                        }
                        e.preventDefault();
                    }));
                    f.buttons.custom.append(b);
                }));
                f.buttons.div.show();
            },
            show: function(d, f, g) {
                if (this.isEmpty(d)) {
                    return false;
                }
                var m = {
                    x: this.win.width(),
                    y: this.win.height()
                }, h = d[0], i = '', j = false, k = h.href, l = this.template, n, height;
                if (d.length === 1 && h.type === 'element') {
                    i = 'element';
                }
                this._setupLoading();
                j = this.visible;
                this.open();
                if (j === false) {
                    this._move();
                }
                this._gallery(d, f);
                f = $.extend(true, {
                    width: 0,
                    height: 0,
                    modal: false,
                    force: '',
                    autoresize: true,
                    move: true,
                    maximized: false,
                    iframe: false,
                    flashvars: '',
                    ratio: 1,
                    onOpen: function() {
                    },
                    onClose: function() {
                    }
                }, f || {
                }, h);
                this.options.onOpen = f.onOpen;
                this.options.onClose = f.onClose;
                var o = this._unserialize(k);
                f = $.extend({
                }, f, o);
                if (f.width && ('' + f.width).indexOf('p') > 0) {
                    f.width = Math.round((m.x - 20) * f.width.substring(0, f.width.indexOf('p')) / 100);
                }
                if (f.height && ('' + f.height).indexOf('p') > 0) {
                    f.height = Math.round((m.y - 20) * f.height.substring(0, f.height.indexOf('p')) / 100);
                }
                this.overlay.options.modal = f.modal;
                var p = l.buttons.max;
                p.removeClass('min');
                p.removeClass('max');
                p.addClass('lightbox-hide');
                this.move = !!f.move;
                this.maximized = !!f.maximized;
                if ($.isArray(f.buttons)) {
                    this._setupCustomButtons(f.buttons, h.element);
                }
                if (l.buttons.custom.is(':empty') === false) {
                    l.buttons.div.show();
                }
                if (this.isEmpty(f.force) === false) {
                    i = f.force;
                } else if (f.iframe) {
                    i = 'iframe';
                } else if (k.match(this.imgsreg)) {
                    i = 'image';
                } else {
                    var q = this.ex({
                        'flash': this.videoregs,
                        'iframe': this.mapsreg
                    }, k, f);
                    if (!!q.type === true) {
                        k = q.href;
                        i = q.type;
                        f.width = q.width;
                        f.height = q.height;
                    }
                    if (!!i === false) {
                        if (k.match(/#/)) {
                            var r = k.substr(k.indexOf('#'));
                            if ($(r).length > 0) {
                                i = 'inline';
                                k = r;
                            } else {
                                i = 'ajax';
                            }
                        } else {
                            i = 'ajax';
                        }
                    }
                }
                if (i === 'image') {
                    l.image = new Image();
                    $(l.image).load(this.proxy(function() {
                        var a = this.template.image;
                        $(a).unbind('load');
                        if (this.visible === false) {
                            return false;
                        }
                        if (f.width) {
                            n = parseInt(f.width, 10);
                            height = parseInt(f.height, 10);
                            f.autoresize = false;
                        } else {
                            a.width = parseInt(a.width * f.ratio, 10);
                            a.height = parseInt(a.height * f.ratio, 10);
                            if (f.maximized) {
                                n = a.width;
                                height = a.height;
                            } else {
                                var b = this._calc(a.width, a.height);
                                n = b.width;
                                height = b.height;
                            }
                        }
                        if (f.autoresize) {
                            if (f.maximized || (!f.maximized && a.width != n && a.height != height)) {
                                l.buttons.div.show();
                                l.buttons.max.removeClass('lightbox-hide');
                                l.buttons.max.addClass((f.maximized ? 'min' : 'max'));
                            }
                        }
                        l.title = (this.isEmpty(f.title)) ? false : $('<div class="title"></div>').html(f.title);
                        this._setupImage();
                        this._resize(n, height);
                    }));
                    this.template.image.onerror = this.proxy(function() {
                        this.error('The requested image cannot be loaded.');
                    });
                    this.template.image.src = k;
                } else if (i === 'jwplayer' && typeof jwplayer !== 'undefined') {
                    if (f.width) {
                        n = f.width;
                        height = f.height;
                    } else {
                        this.error('You have to specify the size.');
                        return false;
                    }
                    var s = 'DV_' + (new Date().getTime()), t = '<div id="' + s + '"></div>';
                    this._setupHTML($(t).css({
                        width: n,
                        height: height
                    }), n, height);
                    this.template.background.bind('complete', this.proxy(function() {
                        this.template.background.unbind('complete');
                        jwplayer(s).setup($.extend(true, {
                            file: k,
                            autostart: true
                        }, f));
                        if (this.visible === false) {
                            return false;
                        }
                    }));
                } else if (i === 'flash' || i === 'inline' || i === 'ajax' || i === 'element') {
                    if (i === 'inline') {
                        var u = $(k);
                        var v = f.source === 'original' ? u : u.clone(true).show();
                        n = f.width > 0 ? f.width : u.outerWidth(true);
                        height = f.height > 0 ? f.height : u.outerHeight(true);
                        this._setupHTML(v, n, height);
                    } else if (i === 'ajax') {
                        if (f.width) {
                            n = f.width;
                            height = f.height;
                        } else {
                            this.error('You have to specify the size.');
                            return false;
                        }
                        if (this.animations.ajax) {
                            this.animations.ajax.abort();
                        }
                        this.animations.ajax = $.ajax($.extend(true, {
                        }, this.options.ajax, f.ajax || {
                        }, {
                            url: k,
                            error: this.proxy(function(a, b, c) {
                                this.error('AJAX Error ' + a.status + ' ' + c + '. Url: ' + k);
                            }),
                            success: this.proxy(function(a) {
                                this._setupHTML($('<div>' + a + '</div>'), n, height);
                            })
                        }));
                    } else if (i === 'flash') {
                        var w = this.swf2html(k, f.width, f.height, f.flashvars);
                        this._setupHTML($(w), f.width, f.height, 'flash');
                    } else if (i === 'element') {
                        n = f.width > 0 ? f.width : h.element.outerWidth(true);
                        height = f.height > 0 ? f.height : h.element.outerHeight(true);
                        this._setupHTML(h.element, n, height);
                    }
                } else if (i === 'iframe') {
                    if (f.width) {
                        n = f.width;
                        height = f.height;
                    } else {
                        this.error('You have to specify the size.');
                        return false;
                    }
                    var t = '<iframe id="IF_' + (new Date().getTime()) + '" frameborder="0" src="' + k + '" style="margin:0; padding:0;"></iframe>';
                    this._setupHTML($(t).css({
                        width: n,
                        height: height
                    }), n, height);
                }
                this.callback = $.isFunction(g) ? g : function(e) {
                };
            },
            _setupImage: function() {
                var a = this.template, b = a.background, c = 'loading';
                b.bind('complete', this.proxy(function() {
                    b.unbind('complete');
                    if (this.visible === false) {
                        return false;
                    }
                    this._setupMode('image');
                    b.empty();
                    a.html.empty();
                    if (a.title) {
                        b.append(a.title);
                    }
                    b.append(a.image);
                    $(a.image).css('background-color', 'rgba(255, 255, 255, 0)');
                    $(a.image).stop().css('opacity', 0).animate({
                        opacity: 1
                    }, (mobile ? this.options.animation.show.duration / 2 : this.options.animation.show.duration), function() {
                        b.removeClass(c);
                    });
                    this.options.onOpen.apply(this);
                }));
            },
            swf2html: function(c, d, e, f) {
                var g = $.extend(true, {
                    classid: 'clsid:D27CDB6E-AE6D-11cf-96B8-444553540000',
                    width: d,
                    height: e,
                    movie: c,
                    src: c,
                    style: 'margin:0; padding:0;',
                    allowFullScreen: 'true',
                    allowscriptaccess: 'always',
                    wmode: 'transparent',
                    autostart: 'true',
                    autoplay: 'true',
                    type: 'application/x-shockwave-flash',
                    flashvars: 'autostart=1&autoplay=1&fullscreenbutton=1'
                }, f);
                var h = '<object ';
                var i = '<embed ';
                var j = '';
                $.each(g, function(a, b) {
                    if (b !== '') {
                        h += a + "=\"" + b + "\" ";
                        i += a + "=\"" + b + "\" ";
                        j += "<param name=\"" + a + "\" value=\"" + b + "\"></param>";
                    }
                });
                var k = h + '>' + j + i + '></embed></object>';
                return k;
            },
            _setupHTML: function(a, b, c, d) {
                var e = this;
                var f = e.options;
                var g = e.template;
                var h = g.background;
                this._setupMode('html');
                this._resize(b + 30, c + 20);
                h.bind('complete', function() {
                    h.removeClass('loading');
                    g.html.append(a);
                    if (d === 'flash' && D('chrome') > -1) {
                        g.html.html(a);
                    }
                    h.unbind('complete');
                    f.onOpen.apply(this);
                });
            },
            _move: function(w, h) {
                var a = $(this.win), d = this.template, e = w != null ? w : d.lightbox.outerWidth(true), f = h != null ? h : d.lightbox.outerHeight(true), y = 0, x = 0;
                var b = {
                    x: a.width(),
                    y: a.height()
                }, c = {
                    x: a.scrollLeft(),
                    y: a.scrollTop()
                };
                x = c.x + ((b.x - e) / 2);
                if (this.visible) {
                    y = c.y + (b.y - f) / 2;
                } else if (this.options.from === 'bottom') {
                    y = (c.y + b.y + 14);
                } else if (this.options.from === 'top') {
                    y = (c.y - f) - 14;
                } else if (this.options.from === 'right') {
                    x = b.x;
                    y = c.y + (b.y - f) / 2;
                } else if (this.options.from === 'left') {
                    x = -e;
                    y = c.y + (b.y - f) / 2;
                }
                if (this.visible) {
                    if (!this.animations.move) {
                        this._morph(d.move, {
                            left: parseInt(x, 10)
                        }, 'move');
                    }
                    this._morph(d.move, {
                        top: parseInt(y, 10)
                    }, 'move');
                } else {
                    d.move.css({
                        left: parseInt(x, 10),
                        top: parseInt(y, 10)
                    });
                }
            },
            _morph: function(d, f, g, h, i) {
                d.animate(f, {
                    queue: i || false,
                    duration: (mobile ? this.options.animation[g].duration / 2 : this.options.animation[g].duration),
                    easing: this.options.animation[g].easing,
                    complete: ($.isFunction(h) ? this.proxy(h, this) : null)
                });
            },
            _resize: function(x, y) {
                var a = this.template;
                if (this.visible) {
                    var b = {
                        x: $(this.win).width(),
                        y: $(this.win).height()
                    }, c = {
                        x: $(this.win).scrollLeft(),
                        y: $(this.win).scrollTop()
                    };
                    var d = Math.max((c.x + (b.x - (x + 14)) / 2), 0), e = Math.max((c.y + (b.y - (y + 14)) / 2), 0);
                    this.animations.move = true;
                    this._morph(a.move.stop(), {
                        left: (this.maximized && d < 0) ? 0 : d,
                        top: (this.maximized && (y + 14) > b.y) ? c.y : e
                    }, 'move', $.proxy(function() {
                        this.move = false;
                    }, this.animations));
                    this._morph(a.html, {
                        height: y - 20
                    }, 'move');
                    this._morph(a.lightbox.stop(), {
                        width: (x + 14),
                        height: y - 20
                    }, 'move', {
                    }, true);
                    this._morph(a.navigator, {
                        width: x
                    }, 'move');
                    this._morph(a.navigator, {
                        top: (y - (a.navigator.height())) / 2
                    }, 'move');
                    this._morph(a.background.stop(), {
                        width: x,
                        height: y
                    }, 'move', function() {
                        $(a.background).trigger('complete');
                    });
                } else {
                    a.html.css({
                        height: y - 20
                    });
                    a.lightbox.css({
                        width: x + 14,
                        height: y - 20
                    });
                    a.background.css({
                        width: x,
                        height: y
                    });
                    a.navigator.css({
                        width: x
                    });
                }
            },
            close: function(a) {
                var b = this.template;
                this.visible = false;
                this.gallery = {
                };
                this.options.onClose();
                var c = b.html.children('.jwplayer');
                if (c.length > 0 && typeof jwplayer !== 'undefined') {
                    jwplayer(c[0]).remove();
                }
                if (mobile) {
                    b.background.empty();
                    b.html.find('iframe').attr('src', '');
                    b.html.hide().empty().show();
                    b.buttons.custom.empty();
                    b.move.css('display', 'none');
                    this._move();
                } else {
                    b.move.animate({
                        opacity: 0,
                        top: '-=40'
                    }, {
                        queue: false,
                        complete: (this.proxy(function() {
                            b.background.empty();
                            b.html.empty();
                            b.buttons.custom.empty();
                            this._move();
                            b.move.css({
                                display: 'none',
                                opacity: 1,
                                overflow: 'visible'
                            });
                        }))
                    });
                }
                this.overlay.hide(this.proxy(function() {
                    if ($.isFunction(this.callback)) {
                        this.callback.apply(this, $.makeArray(a));
                    }
                }));
                b.background.stop(true, false).unbind('complete');
            },
            open: function() {
                this.visible = true;
                this.template.move.stop().css({
                    opacity: 1,
                    display: 'block',
                    overflow: 'visible'
                }).show();
                this.overlay.show();
            },
            shake: function() {
                var z = this.options.animation.shake, x = z.distance, d = z.duration, t = z.transition, o = z.loops, l = this.template.move.position().left, e = this.template.move;
                for (var i = 0; i < o; i++) {
                    e.animate({
                        left: l + x
                    }, d, t);
                    e.animate({
                        left: l - x
                    }, d, t);
                }
                e.animate({
                    left: l + x
                }, d, t);
                e.animate({
                    left: l
                }, d, t);
            },
            _setupMode: function(a) {
                if (a !== this.mode) {
                    var b = 'mode-';
                    this.template.lightbox.removeClass(b + this.mode).addClass(b + a);
                    this.mode = a;
                }
                this.template.move.css('overflow', 'visible');
            },
            error: function(a) {
                alert(a);
                this.close();
            },
            _unserialize: function(d) {
                var e = /lightbox\[([^\]]*)?\]$/i, f = {};
                if (d.match(/#/)) {
                    d = d.slice(0, d.indexOf('#'));
                }
                d = d.slice(d.indexOf('?') + 1).split('&');
                $.each(d, function() {
                    var a = this.split('='), b = a[0], c = a[1];
                    if (b.match(e)) {
                        if (isFinite(c)) {
                            c = parseFloat(c);
                        } else if (c.toLowerCase() == 'true') {
                            c = true;
                        } else if (c.toLowerCase() == 'false') {
                            c = false;
                        }
                        f[b.match(e)[1]] = c;
                    }
                });
                return f;
            },
            _calc: function(x, y) {
                var a = this.options.maxSize.width > 0 ? this.options.maxSize.width : this.win.width() - 50;
                var b = this.options.maxSize.height > 0 ? this.options.maxSize.height : this.win.height() - 50;
                if (x > a) {
                    y = y * (a / x);
                    x = a;
                    if (y > b) {
                        x = x * (b / y);
                        y = b;
                    }
                } else if (y > b) {
                    x = x * (b / y);
                    y = b;
                    if (x > a) {
                        y = y * (a / x);
                        x = a;
                    }
                }
                return {
                    width: parseInt(x, 10),
                    height: parseInt(y, 10)
                };
            },
            _setupLoading: function() {
                var a = this.options.style, b = this.template, c = b.background;
                this._setupMode('image');
                c.children().stop(true);
                c.empty();
                b.html.empty();
                b.buttons.div.hide();
                b.buttons.div.css('width');
                c.addClass('loading');
                if (this.visible === false) {
                    this._move(a['width'], a['height']);
                    this._resize(a['width'], a['height']);
                }
            },
            _cascade: function() {
                var a = this, b = a.template.buttons, c = a.template.image, e = {};
                b.max.removeClass('min max').addClass((a.maximized) ? 'max' : 'min');
                a._setupLoading();
                a._setupImage();
                b.div.show();
                if (a.maximized) {
                    e = a._calc(c.width, c.height);
                } else {
                    e = c;
                }
                a._resize(e.width, e.height);
                a.maximized = !a.maximized;
            },
            getOptions: function(a) {
                var a = $(a);
                return $.extend({
                }, {
                    href: a.attr('href'),
                    rel: ($.trim(a.attr('data-rel') || a.attr('rel'))),
                    relent: a.attr('data-rel') ? 'data-rel' : 'rel',
                    title: $.trim(a.attr('data-title') || a.attr('title')),
                    element: a[0]
                }, ($.parseJSON((a.attr('data-options') || '{}').replace(/\'/g, '"')) || {
                }));
            },
            link: function(b, c) {
                var d = $(c.element), e = this.getOptions(d), f = e.rel, g = e.relent, h = c.options, j = [];
                d.blur();
                if (c.gallery) {
                    j = c.gallery;
                } else if (this.isEmpty(f) || f === 'nofollow') {
                    j = [e];
                } else {
                    var k = [], l = [], m = false;
                    $("a[" + g + "], area[" + g + "]", this.ownerDocument).filter("[" + g + "=\"" + f + "\"]").each($.proxy(function(i, a) {
                        if (d[0] === a) {
                            k.unshift(this.getOptions(a));
                            m = true;
                        } else if (m === false) {
                            l.push(this.getOptions(a));
                        } else {
                            k.push(this.getOptions(a));
                        }
                    }, this));
                    j = k.concat(l);
                }
                $.lightbox(j, h, c.callback, d);
                return false;
            },
            isEmpty: function(a) {
                if (a == null) {
                    return true;
                }
                if (Object.prototype.toString.call(a) === '[object String]' || $.type(a) === 'array') {
                    return a.length === 0;
                }
            }
        },
        lightbox: function(a, b, c) {
            var d = [];
            if ($.ClassyLightbox.isEmpty(a)) {
                return $.ClassyLightbox;
            }
            if ($.type(a) === 'string') {
                d = [$.extend({
                    }, {
                        href: a
                    }, b)];
            } else if ($.type(a) === 'array') {
                var e = a[0];
                if ($.type(e) === 'string') {
                    for (var i = 0; i < a.length; i++) {
                        d[i] = $.extend({
                        }, {
                            href: a[i]
                        }, b);
                    }
                } else if ($.type(e) === 'object') {
                    for (var i = 0; i < a.length; i++) {
                        d[i] = $.extend({
                        }, b, a[i]);
                    }
                }
            } else if ($.type(a) === 'object' && a[0].nodeType) {
                d = [$.extend({
                    }, {
                        type: 'element',
                        href: '#',
                        element: a
                    }, b)];
            }
            return $.ClassyLightbox.show(d, b, c);
        }
    });
    $.fn.lightbox = function(a, b) {
        return $(this).on('click', function(e) {
            e.preventDefault();
            e.stopImmediatePropagation();
            return $.proxy($.ClassyLightbox.link, $.ClassyLightbox)(e, $.extend({
            }, {
                selector: this.selector,
                options: a,
                callback: b
            }, {
                element: this
            }));
        });
    };
    $(function() {
        $.ClassyLightbox._create();
    });
})(jQuery, window, document);