/*! jquery.simplescroll
 * 
 * Copyright (c) 2016 @literallylara
 * Under the MIT license:
 * http://www.opensource.org/licenses/mit-license.php
 */

(function(factory)
{
	if(typeof define == "function" && define.amd)
	{
		define(["jquery"],factory);
	}
	else if(typeof module !== "undefined" && module.exports)
	{
		module.exports = factory;
	}
	else
	{
		factory(window.jQuery || window.$);
	}
}(function($)
{
	"use strict";

	function makeScrollbar($el, layout, style, axis)
	{
		axis = axis || "x"
		
		let behaviour = style["overflow-" + axis]

		if (axis == "x") makeScrollbar($el, layout, style, "y")
		if (!~["auto","scroll"].indexOf(behaviour)) return;

		// define universal properties
		let bottom = axis == "x" ? (layout[0] == "top" ? "top" : "bottom") : (layout[1] == "left" ? "left" : "right") 
		let left   = axis == "x" ? "left"   : "top" 
		let width  = axis == "x" ? "height" : "width" 
		let length = axis == "x" ? "width"  : "height"
		let Length = axis == "x" ? "Width"  : "Height"

		let $track  = $("<div class='ss-track ss-track-" + axis + "'>")
		let $handle = $("<div class='ss-handle ss-handle-" + axis + "'>")

		// style handle
		$handle.css({ position: "absolute", top: 0, left: 0, width: "100%", height: "100%", background: "#666", cursor: "pointer" })
		.css(width,"100%")
		.css(length, ($el[0]["offset"+Length]/$el[0]["scroll"+Length]*100) + "%")
		.appendTo($track)

		// style track
		$track.css({ position: "absolute", zIndex: 98, background: "#333" })
		.css(width,"16px")
		.css(length,"100%")
		.css(left,axis=="x"&&layout[1]=="left" || axis=="y"&&layout[0]=="top" ? "16px" : 0)
		.css(bottom,0)
		.appendTo($el)
		
		// register events (duh)
		registerEvents($el, $track, $handle, axis, length, Length, behaviour)

		// add corner element?
		if ($el.find(".ss-track").length == 2)
		{
			$("<div class='ss-corner'>").css({ position: "absolute", zIndex: 98, width: "16px", height: "16px", background: "#333" })
			.css(layout[0]=="top"?"top":"bottom",0).css(layout[1]=="left"?"left":"right",0).appendTo($el)

			$el.find(".ss-track-x").css("width",  "calc(100% - 16px)")
			$el.find(".ss-track-y").css("height", "calc(100% - 16px)")
		}
	}

	function registerEvents($el, $tr, $hd, ax, le, Le, be)
	{
		let down, focus

		let oa = ax == "x" ? "y" : "x" // other axis
		let Ax = ax.toUpperCase()      // upper case axis

		let $ot // other track
		let $cn // corner

		let om // offset mouse
		let lo // length offset
		let ls // length scroll
		let lh // length handle
		let lt // length track
		let sp // scroll percent

		let te = {} // translation elements
		let th  = 0 // translation handle
		let tho = 0 // translation handle offset

		// drag events
		$hd.on("mousedown", dragStart)
		$(document).on("mousemove", drag)
		$(document).on("mouseup", dragEnd)

		// focus & scroll events
		$el.on("mouseover", function() { focus = true })
		$el.on("mouseout", function() { focus = false })
		document.addEventListener("wheel", drag)
		
		// resize events
		$(window).on("resize", resize)
		$el.on("ss-update", resize)

		function dragStart(e)
		{
			if (down) return; down = true

			e.preventDefault()
			
			// update mouse offset
			om = e["page"+Ax]
		}

		function drag(e)
		{
			if (e.type == "mousemove" && !down) return
			e.preventDefault()

			// translate handle by drag
			if (e.type == "mousemove")
			{
				tho = e["page"+Ax]-om
				sp = $hd.position()[ax=="x"?"left":"top"] / (lt-lh)
				
				$hd.css("transform", `translate${Ax}(${Math.min(Math.max(th+tho,0),lt-lh)}px)`)
			}
			// translate handle by scroll
			else if (e.type == "wheel" && focus)
			{
				th = Math.min(Math.max(th+e["delta"+Ax],0),lt-lh)
				sp = th/(lt-lh)

				$hd.css("transform", `translate${Ax}(${sp*(lt-lh)}px`)
			}

			// scroll content
			$el[0]["scroll"+(ax=="x"?"Left":"Top")] = sp * (ls-lo)

			// translate other elements
			te[ax] = Math.floor(sp * (ls-lo))
			te[oa] = $ot.data("ss-translate") || 0
			$tr.add($ot).add($cn).css("transform", `translate(${te.x}px,${te.y}px)`)
			$tr.data("ss-translate", te[ax])
		}

		function dragEnd(e)
		{
			if (!down) return; down = false

			// add handle translation offset to total translation and clamp the result
			th = Math.min(Math.max(th+tho,0),lt-lh)
		}

		function resize()
		{
			if (!$ot) $ot = $tr.siblings(".ss-track")
			if (!$cn) $cn = $tr.siblings(".ss-corner")

			// hide scrollbar momentarily to get correct scroll lengths
			let tv = $ot.is(":visible");
			let $all = $tr.add($ot).add($cn).hide()

			// update container lengths
			lo = $el[0]["offset"+Le]
			ls = $el[0]["scroll"+Le]
			
			// unhide scrollbar
			$ot.toggle(tv)
			$tr.add($cn).show()

			// update scrollbar lengths
			lh = $hd[le]()
			lt = $tr[le]()

			// auto hide
			be == "auto" && $tr.add($cn).toggle(lo < ls)

			// adjust length
			$hd.css(le, ($el[0]["offset"+Le]/$el[0]["scroll"+Le]*100) + "%")

			// correct scroll offset
			$el[0]["scroll"+(ax=="x"?"Left":"Top")] = sp * (ls-lo)

			// correct element position
			te[ax] = Math.floor(sp * (ls-lo))
			te[oa] = $ot.data("ss-translate") || 0
			$all.css("transform", `translate(${te.x}px,${te.y}px)`)
			$tr.data("ss-translate", te[ax])

			// correct handle position
			$hd.css("transform", `translate${Ax}(${sp*(lt-lh)}px`)
		}
	}

	$.fn.simplescroll = function(opts) { this.each(function()
	{
		let $el = $(this)
		
		if (opts == "update") { $el.trigger("ss-update"); return }

		let layout = $el.data("simplescroll").split("|")
		let style = getComputedStyle($el[0])

		makeScrollbar($el, layout, style)

		$el.css({ position: "relative", overflow: "hidden" }).trigger("resize")
	})}
}))