## Contributing.

First and foremost, if you've made it this far: __you are awesome__. Thanks for even considering contributing to open source.

Here's how you can contribute to this repo:

```bash
# 1. Make your edits.

# 2. Views the demos in your browser, and test your changes thoroughly.
#    Create new demos as needed.
grunt serve --port=8000

# 3. Hint, test, and compile.
grunt

# 4. Commit your changes, closing issues as appropriate.
git commit -am "fixes #30 - my awesome fix"

# 5. If you're changing Pep's source code (not readmes/demos/etc), tag the commit so Bower can get the latest and greatest.
#    Be sure to increment the version appropriately.
#    Also change the version in package.json
vi package.json
git tag -a v0.5.12 -m 'my awesome version v0.5.12'

# 6. Create pull request with changes.
# or....
# 6. If you have privileges, push changes and tags:
git push origin master
git push origin --tags
````

## Need help?
As always, find me on Twitter for help.

| ![twitter/brianmgonzalez](http://gravatar.com/avatar/f6363fe1d9aadb1c3f07ba7867f0e854?s=70](http://twitter.com/brianmgonzalez "Follow @brianmgonzalez on Twitter") |
|---|
| [Brian Gonzalez](http://briangonzalez.org) |
