# Add Dialog

> 3.1.2

A jQuery plugin used to create Material Design themed dialog popup.

```JavaScript
$add.Dialog("<p>Hello World</p>");
```

## Importing
Because this is a [jQuery](http://jquery.com) plugin, jQuery must be first imported before this plugin. Any version of jQuery should work.

```HTML
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
```

Then copy `addDialog.js` and `addDialog.css` from the distribution (`dist`) directory into your project and import it into your page.

```HTML
<link rel='stylesheet' href='path/to/addDialog.css' />
<script src='path/to/addDialog.js'></script>
```

### Theming
The CSS was compiled from Sass (SCSS), you can change the color and the theme by editing the variables in `src/addDialog.scss`, the colors can be set to any color and `$theme` can be set to `"dark"` or `"light"`. After making your changes you will need to recompile the SASS, if you do not have sass installed on your system visit [SassMeister.com](http://www.sassmeister.com/) for an easy to use online compiler (you will need to manually import the partials).

### Obj.JS
This plugin is built using the [Obj.JS 2.1+](https://github.com/addui/ObjJS) framework, but it is included in the distribution JS file (`dist/addDialog.js`). If you are already using Obj.JS on your page you should import the JS file from source instead (`src/addDialog.js`) to avoid loading duplicate code.

## How to Use
Once the script and styles are imported onto your page you can start using addDialog **after the Document is ready**.

To create a base dialog use `$add.Dialog(contents [, settings])`

```JavaScript
$add.Dialog("<p>Hello World</p>", {
  width: 350,
  hieght: 250
});
```

![](res/basic.png)

You can pass any HTML into the first parameter as the contents of the dialog. Some very basic styles are applied to the content for spacing but the content should inherit the styles of your page.

### Settings

The second parameter (settings) is an object which can contain any of the following properties. This parameter is optional.

- **width**
  - This is the width of the dialog
  - *default =* `280`
- **height**
  - This is the height of the dialog
  - *default =* `392`
- **title**
  - The title that will appear large and bold on top of the dialog.
  - *default =* `null`
- **class**
  - An extra "class" attribute to be added to the dialog for extra styling.
  - *default =* `""`
- **falseBtnText**
  - The text that will appear on the "cancel" button (left) on the bottom of the dialog.
  - *default =* `null`
- **falseBtnAction**
  - A callback function that will be executed when the user clicks the "cancel" button (left) on the bottom of the dialog.
  - If the function returns **`false`** (not `undefined`) the dialog will **not** be closed.
  - *default =* `null`
- **trueBtnText**
  - The text that will appear on the "confirm" button (right) on the bottom of the dialog.
  - *default =* `"OK"`
- **trueBtnAction**
  - A callback function that will be executed when the user clicks the "confirm" button (right) on the bottom of the dialog, or presses enter while an input is focused (submits the form).
  - If the function returns **`false`** (not `undefined`) the dialog will **not** be closed.
  - *default =* `null`
- **enterEsc**
  - When set to `true` pressing the "ESC" key will "cancel" the dialog, and pressing the "enter" key will "confirm" the dialog.
  - **Note:** Because the dialog is a `<form>` element, pressing the "enter" key while focused on an input field will always automatically "confirm" the dialog, even when this setting is disabled.
  - *default =* `false`

## Special Dialogs

This plugins comes with 7 special dialogs, these dialogs are just normal dialogs with different default settings.

### Alert
To produce an Alert Dialog use `$add.Dialog.alert(contents [, settings]);

```JavaScript
$add.Dialog.alert("<p>This is an alert.</p>");
```

![](res/alert.png)

The default settings for this dialog are:

```JavaScript
{
  title: null,
  width: 336,
  height: 224,
  falseBtnText: null,
  falseBtnAction: null,
  trueBtnText: "Ok",
  trueBtnAction: null,
  class: "",
  enterEsc: false
}
```

### Confirm
To produce a Confirm Dialog use `$add.Dialog.confirm(confirmText [, callback [, yesText [, noText [, settings]]]])`

```JavaScript
$add.Dialog.confirm("Are you sure?");
```

![](res/confirm.png)

The default settings for the dialog are:

```JavaScript
{
  title: null,
  width: 336,
  height: 168,
  falseBtnText: (noText || "No"),
  falseBtnAction: function(){
    callback(false);
  },
  trueBtnText: (yesText || "Yes"),
  trueBtnAction: function(){
    callback(true);
  },
  class: "",
  enterEsc: false
}
```

**Note:** The `confirmText` parameter will automatically be wrapped in `<p>` tags and inserted as the dialog contents.

### Prompt
To produce a Prompt Dialog use `$add.Dialog.prompt(question [, callback [, settings]])`
When using a "prompt" dialog, an extra setting named "placeholder" can be used to set the placeholder text of the input.

```JavaScript
$add.Dialog.prompt("What is your name?", function(answer){
  console.log(answer);
}, {
  placeholder: "Name"
});
```

![](res/prompt.png)

The default settings for this dialog are:

```JavaScript
{
  title: question,
  width: 336,
  height: 224,
  falseBtnText: null,
  falseBtnAction: null,
  trueBtnText: "Submit",
  trueBtnAction: function(data){
    if(callback) callback(data.answer)
  },
  class: "",
  enterEsc: false,
  placeholder: ""
}
```

*Note:* The contents is single input (type=text) with a name of "answer" and the placeholder specified by the setting.


### Error
To produce an Error Dialog use `$add.Dialog.error(contents [, settings])`

```JavaScript
$add.Dialog.error("<p>Something went wrong!</p>");
```

![](res/error.png)

The default settings for this dialog are:

```JavaScript
{
  title: "Error",
  width: 336,
  height: 336,
  falseBtnText: null,
  falseBtnAction: null,
  trueBtnText: "Ok",
  trueBtnAction: null,
  class: "error",
  enterEsc: false
}
```

The `error` class is added to style the dialog using the colors specified by the `$error` SASS variable.

### Warning
To produce an Warning Dialog use `$add.Dialog.warning(contents [, settings])`

```JavaScript
$add.Dialog.warning("<p>That is not a good idea!</p>");
```

![](res/warning.png)

The default settings for this dialog are:

```JavaScript
{
  title: "Warning",
  width: 336,
  height: 336,
  falseBtnText: null,
  falseBtnAction: null,
  trueBtnText: "Ok",
  trueBtnAction: null,
  class: "warning",
  enterEsc: false
}
```

The `warning` class is added to style the dialog using the colors specified by the `$warning` SASS variable.

### Success
To produce an Success Dialog use `$add.Dialog.success(contents [, settings])`

```JavaScript
$add.Dialog.success("<p>Awesome, it worked!</p>");
```

![](res/success.png)

The default settings for this dialog are:

```JavaScript
{
  title: "Success",
  width: 336,
  height: 336,
  falseBtnText: null,
  falseBtnAction: null,
  trueBtnText: "Ok",
  trueBtnAction: null,
  class: "success",
  enterEsc: false
}
```

The `success` class is added to style the dialog using the colors specified by the `$success` SASS variable.

### Accent
To produce a Dialog that uses the `$accent` color (Sass variable) for the title and buttons use `$add.Dialog.accent(contents [, settings])`

```JavaScript
$add.Dialog.accent("<p>Wow accent colors</p>", {
  title: "Dialog Title"
});
```

![](res/accent.png)

The default settings for this dialog are:

```JavaScript
{
  title: null,
  width: 280,
  height: 392,
  falseBtnText: null,
  falseBtnAction: null,
  trueBtnText: "Ok",
  trueBtnAction: null,
  class: "accent",
  enterEsc: false
}
```

The `accent` class is added to style the dialog using the colors specified by the `$accent` SASS variable.

## DOM Dialog
You can specify a Dialog to be automatically opened when the page loads by creating a `<div>` element anywhere on your page with a `data-addui` attribute with a value of `"dialog"`. The contents of this `<div>` will be the the dialogs contents. You can set the settings of the dialog by giving the `<div>` attributes of `data-{setting name}="{setting value}"`.

```HTML
<div
  data-addui='dialog'
  data-title="Dialog Title"
  data-width="400"
  data-height="300"
>
  <p>Dialog Contents</p>
</div>
```

![](res/dom-dialog.png)


#License

This software is property of [**Dustin Poissant**](http://github.com/dustinpoissat).

This software is distributed AS-IS with no warranties/guarantees either expressed or implied.

This software is Licensed under [CC BY-NC-SA 3.0 US](https://creativecommons.org/licenses/by-nc-sa/3.0/us/).
