# Contributing

When contributing to this repository, please **first discuss the change you wish to make via issue**,
email, or any other method with the owners of this repository before making a change. 

## Pull Request Process

1. Install all the dependencies using `npm install`
2. Make your changes and test them. Note that depending on your changes you may also have to modify existing tests or create new ones.
3. **Run the tests** using `npm run test`
4. **Build** the minified version using `npm run build`
5. **Update the docs** (index.html) with the changes. If it is a new feature ensure to include it in the first example.
6. **Increase the version numbers in every file** where the version number is present to the new version that this Pull Request would represent. The versioning scheme we use is [SemVer](http://semver.org/).

## Optional

Consider making your changes also in [InstagramFeed](https://github.com/jsanahuja/InstagramFeed).