# bootstrap-loadingbtn
基于bootstrap V3的按钮加载效果

## 加载按钮

### 配置参数 (可选)
可通过调用config方法进行参数的配置，写法如下：

```js
$('.btn-add-success').loadingbtn('config',{
    html:true,
    normalTpl:'提交成功示例',
    successTpl:'提交成功',
    loadingTpl:'提交中...',
    dangerTpl:'提交失败',
});
```

* html:是否传递的是html  如果不传，则默认是获取text （此处是防止xss攻击）
* normalTpl：按钮初始化传递按钮内容
* successTpl：按钮成功状态传递按钮内容
* loadingTpl：按钮加载中状态传递内容
* dangerTpl：按钮加载失败状态传递内容

传递的内容当`html`参数为true的时候，参数模版可以传递html内容

例如：

```html
<button type="button" class="btn btn-primary btn-lg btn-add-success">
    提交
</button>
```

### 单独调用

单独调用形式如下:

```js

//按钮加载中
$(".btn").loadingbtn('loading');

//按钮加载成功状态
$(".btn").loadingbtn('success');

//按钮加载失败状态
$(".btn").loadingbtn('fail');

//按钮加载失败之后还原初始状态
$(".btn").loadingbtn('fail',{reset:false});

//按钮手动重置状态
$(".btn").loadingbtn('reset');
```

### 监听事件

```js
$('.btn').on('loading.bs.loadbtn',function(){
    console.log('loading.bs.loadbtn 加载中')
})

$('.btn').on('success.bs.loadbtn',function(){
    console.log('success.bs.loadbtn 成功')
})

$('.btn').on('fail.bs.loadbtn',function(){
    console.log('success.bs.loadbtn 失败')
})

$('.btn').on('reset.bs.loadbtn',function(){
    console.log('reset.bs.loadbtn 重置')
})
```
