# Nifty Nav
Nifty Nav is a quick and easy navigation plugin using Sass and jQuery. It makes
making navigation systems a little better. Built by the awesome people over at [factor1](http://factor1studios.com).

## Getting Started

##### 1. Install Nifty Nav with `npm` or `bower`

```
npm install nifty-nav --save
## OR
bower install nifty-nav --save
```

##### 2. Import the Nifty Nav styles & settings in your `.scss` file

To use the default settings:

```scss
@import nifty-nav/settings;
@import nifty-nav/nifty-nav;
```

To customize the settings, copy `settings.scss` to your project folder and include
it before `nifty-nav`. This example moves `settings.scss` to a folder called
`settings` and renames it to `nifty-nav-settings`:

```scss
@import settings/nifty-nav-settings;
@import nifty-nav/nifty-nav;
```

##### 3. Include the `nifty-nav.js`
Include the `nifty-nav.js` in your build either inline or within a Gulp or Grunt
task.

### Quick Setup
To use Nifty Nav without compiling and with the default settings, clone the Nifty Nav repo and use
`nifty-nav.min.css` found in `dist/css/` and `nifty-nav.min.js` found in `dist/js/`.

```html
<html>
  <head>
    <link rel="stylesheet" href="path/to/file/nifty-nav.min.css">
  </head>
  <body>
   ...
   <script src="path/to/file/nifty-nav.min.js"></script>
  </body>
</html>
```

## Adding The Hamburger
To add the hamburger to your site:

```html
<a id="nifty-nav-toggle"><span></span></a>
```

## Nifty Nav Options/Settings
Nifty Nav has five `jQuery` settings, and some `scss` settings.

- `subMenus` controls if Nifty Nav should allow toggling of sub-menus. Default: `false`.
- `subMenuParentLink` controls if a parent menu navigation link should be followed when clicked. Default: `false`.
- `mask` controls if Nifty Nav should show the mask that covers the page. Default: `true`.
- `itemClickClose` controls if Nifty Nav should close when a nav item with the class of `nifty-nav-item`
is clicked. Default: `true`.
- `panelPosition` lets you control the `display:` value of the `.nifty-panel` element. Default: `absolute`.

> **NOTE:**  When using `panelPosition: 'fixed'` a class of `.nifty-lock` is added
> to the `<body>`. This is to prevent the page from scrolling and allow the user to scroll
> through nav items instead. To change this functionality simply override the `.nifty-lock` class.


`Scss` settings control visual aspects of nifty nav:

- `$header-index` sets the z-index of the `<header>` element
- `$panel-color` sets the color of the dropdown.
- `$panel-top-distance` sets the panel distance from the top of the viewport.
- `$panel-width` sets the panel width.
- `$panel-index` sets the z-index of the Nifty Nav panel.
- `$mask-color` sets the color and opacity of the mask.
- `$mask-index` sets the z-index of the mask.
- `$hamburger-color` sets the hamburger color.
- `$hamburger-color-active` sets the color of the hamburger when the panel is open.
- `$hamburger-position-top` sets the distance from the top of the containing element.
- `$hamburger-position-x` sets the distance from the left/right of the containing element.
- `$hamburger-position-left` - default is `true`. If false, the hamburger floats to the right.

## Initializing Nifty Nav
To use Nifty Nav, initialize it at the bottom of your page before the closing `</body>` or in an external JavaScript file (recommended).

```js
// Nifty Nav with default settings
$(document).ready(function(){
	$('#nifty-nav-toggle').niftyNav();
});

// Nifty Nav without the mask and with sub-menu toggles
$(document).ready(function(){
  niftyNav({
    mask: false,
    subMenus: true
  });
});
```


# Issues / Bugs / Contributions#
If you have feedback, find a bug, or want to make contributions, please don't hesitate
to open an issue or make a pull request.
