slidethrough
============

A simple to use jQyery slideshow plugin with options.

Installation
------------

Simply include jquery.slidethrough.js in your head element. Note that a version of jQuery is required and should come before the plugin

	<script type="text/javascript" src="http://code.jquery.com/jquery-2.0.3.min.js"></script>
	<script type="text/javascript" src="js/jquery.slidethrough.js"></script>

Usage
-----

_HTML_

Recommended slideshow markup.

	<div class='slideshow'>
		
		<div class='slideshowinner'>
			<div class='slide'>
				<img src='images/image-01.jpg' alt='' />
			</div>
			<div class='slide'>
				<img src='images/image-02.jpg' alt='' />
			</div>
			<div class='slide'>
				<img src='images/image-03.jpg' alt='' />
			</div>
		</div>
		
		<a href='#' class='sbtn prev'>Previous</a>
		<a href='#' class='sbtn next'>Next</a>			
		
	</div>

_CSS_

Edit slideshow width and height at will (try 100%/100% for full-screen). Would recommend to leave the rest as is.

	.slideshow {
		width: 640px;
		height: 426px;
		position: relative;
		overflow: hidden;
	}
	.slide,
	.slide img {
		position: absolute;
		top: 0;
		left: 0;
		width: 100%;
	}
	.slide {
		height: 100%;
	}
	.slide img {
		display: block;
		z-index: 1;
	}
	.sbtn {
		position: absolute;
		cursor: pointer;
		text-indent: -99999px;
		top: 0;	
		width: 50%;
		height: 100%;
		cursor: pointer;
		z-index: 10;
	}
	.sbtn.next {
		right: 0;	
	}
	.sbtn.prev {
		left: 0;	
	}

_JS_

A simple plugin call (See Option section for passing on different settings).

	$(".slideshow").slideThrough();


Options
-------

The plugin has several options, all quite self-exaplantory.

_speed_

	$(".slideshow").slideThrough({
        speed: 300
	});	

_easing_

Use [jQuery Easing Plugin](http://gsgd.co.uk/sandbox/jquery/easing/) for advanced easing: 

	$(".slideshow").slideThrough({
        easing: "swing"
	});

_width_

Optional. By default it will take slideshow element width, but you can define a number yourself

	$(".slideshow").slideThrough({
        easing: ""
	});	

_effect_

The plugin supports two types of effects, of which one is default `slide`, while the other is `fade`

	$(".slideshow").slideThrough({
        fx: "slide"
	});

See all default options:

	$(".slideshow").slideThrough({
		speed: 300,
		easing: "swing",
		width: 640,
		fx: "slide"
	});	


