/*
== jQuery slideshow plugin == 
Version: 1
Plugin URI: https://github.com/arnasziedas/slidethrough
Author: Arnas Ziedavicius
Author URI: http://arnasziedavicius.com/
License: MIT License (MIT)
*/

(function($) {

    $.fn.slideThrough = function(options) {
    	
    	// Default settings
        var settings = $.extend({
            speed: 300,
            easing: "linear",
            width: "",
            fx: "slide"
        }, options);

        // Go through each slideshow */
        return this.each(function () {
			
			var _this =  $(this);
			
			// Add active class to the first slide, hide the rest
            _this.find(".slide:first").addClass("slide-active");
			_this.find('.slide:not(.slide-active)').hide();

			// Hide slideshow buttons if there's only one
            if (_this.find(".slide").length < 2) {
                _this.find(".sbtn").hide();
            }

            _this.find(".sbtn").click(function(e) {
                e.preventDefault();
                var speed = settings.speed,
                	easing = settings.easing,
                	fx = settings.fx,
                	direction = ($(this).hasClass("next")) ? "next" : "prev";
                var width = (settings.width) ? settings.width : _this.width() ;
                slideshowMove(direction, easing, speed, width, fx);
            });

        });

        function slideshowMove(direction, easing, speed, width, fx) {

            var slides = $(".slide"),
            	slide = $(".slide-active");
			
            if (direction == "prev") {           	
				
				// Move the slide in view
				if (fx=="slide") {
					slide.stop().animate({
					    left: width
					}, speed, easing, function () {
					    $(this).hide(0).css({
					        left: 0
					    });
					});
                } else if (fx=="fade") {
					slide.fadeOut(speed);
                }

                // Select the previous slide
                slide = slide.prev();

                // If the there's no previous slide, select the last slide
                if (!slide.length) {
                    slide = slides.last();
                }
				
				// Move the previous slide
				if (fx=="slide") {
	                slide.css({
	                    left: -width
	                }).show(0).stop().animate({
	                    left: 0
	                }, speed, easing);
                } else if (fx=="fade") {
	                slide.fadeIn(speed);
                }

            } else {
            	
				// Move the slide in view
            	if (fx=="slide") {
	                slide.stop().animate({
	                    left: -width
	                }, speed, easing, function () {
	                    $(this).hide(0).css({
	                        left: 0
	                    });
	                });           	
				} else if (fx=="fade") {
					slide.fadeOut(speed);
				}

				// Select the next slide
                slide = slide.next();

                // If the there's no next slide, select the first slide
                if (!slide.length) {
                    slide = slides.first();
                }
				
				// Move the next slide				
				if (fx=="slide") {
	                slide.css({
	                    left: width
	                }).show(0).stop().animate({
	                    left: 0
	                }, speed, easing);
                } else if (fx=="fade") {
	                slide.fadeIn(speed);
                }

            }

            slide.addClass("slide-active");
            $(".slide").not(slide).removeClass("slide-active");            

        }

    }

}(jQuery));