
var ovl;


// When document is ready
_app.addEvent( window, 'load', function(){
	
	ovl = new Overlay();		
	
	_app.addEvent( document.getElementById('anchors'), 'click', anchorsClick );
	
} );
	
	
// When the div with id is clicked this function is called	
function anchorsClick( e )
{
	// Get event object
	if( !e ) var e = window.event;
	
	// Get event target
	var target = e.target || e.srcElement;
	
	// Prevent default action
	if( e.preventDefault )
		e.preventDefault();
	else
		e.returnValue = false;	
		
	// If the target of the event is not an anchor tag return
	if( target.tagName !== 'A' ) return;		
	
	// Get hash tag
	var sHref = (/\#block_\d+/g).exec( target.href )[0];
	
	// Get element reference
	var refElement = document.getElementById( sHref.replace('#','') );
	
	// Create overlay snippet
	var div = document.createElement( 'div' );
	div.className = refElement.className;
	div.innerHTML = refElement.innerHTML;
	
	
	// Add content to overlay and resize it
	ovl.content( { html: div } )
		.resize({
			width: _app.elementRealWidth( refElement ),
			height: _app.elementRealHeight( refElement )
		});
			
	
	// If the target is first anchor
	if( sHref === '#block_01' || sHref === '#block_03' )
	{
		// Disable close button and fallback click
		ovl.disableCloseBtn().disableFallbackClick();	
	}	
	else
	{
		// Enable close button and fallback click
		ovl.enableCloseBtn().enableFallbackClick();	
	}	
			
		
	// Display overlay		
	ovl.show({
		callback: function(){ // After the overlay has been displayed
			
			// If the first anchor was clicked
			if( sHref === '#block_01' )
			{
				// click event for its child anchors
				function optClick( e )
				{
					// Get event object
					if( !e ) var e = window.event;
					
					// Prevent default action
					if( e.preventDefault )
						e.preventDefault();
					else
						e.returnValue = false;	
						
					ovl.hide();		
				}
				
				// Get anchors
				var opt = document.getElementById('overlay').getElementsByTagName('div')[0].getElementsByTagName('a');
				
				// For each anchor attach event
				for( var i = 0; i < opt.length; i++ )
				{
					_app.addEvent( opt[i], 'click', optClick );
				}
			}
			else if( sHref === '#block_03' )
			{
				setTimeout( function(){ ovl.hide(); }, 5000 );	
			}
			else
			{
				// Do nothing
			}
			
		}
	});
	

} // function anchorsClick

