"use strict";

(function($) {
	var slidons = {};
	var Slidon = require("./slidon");

	$.fn.slidon = function(options) {
		var args = arguments;
		var returnValue = false;

		/* 
		 * NOTE: When using carousel Slidons, in order to make its effect some
		 * elements in the Slidon are duplicated and removed when an iteration
		 * start and gets completed. Client might select some elements during
		 * this period of time and he might get in the selected elements those
		 * that are about to be removed, normally this won't be a problem as
		 * they are exact copies and the operation applied will be done over 
		 * both of them, but client might be relying on elements number and 
		 * indexes for example which might bring troubles so its a good practice
		 * everytime you select an element INSIDE a Slidon to send the filter
		 * command over the selected resources to filter this cloned elements
		 * that are about to get removed when iteration completes.
		 *
		 */

		if (options === "filter") {
			var elements = [];

			this.each(function() {
				if (!$(this).parents(".slidon-remove").length) {
					elements.push($(this));
				}
			});

			return elements;
		}

		this.filter("div").each(function() {
			if (typeof options == "string") {

				/* Process Slidon command */

				var slidon = slidons[parseInt($(this).attr("data-slidon"))];

				if (!slidon) {
					console.log("Slidon command error! you are trying to send a command ( '" + options + "' ) to an element which was still not initializated as a Slidon or removed from DOM", $(this));
					return true; // continue
				}

				returnValue = slidon.command.apply(slidon, args);

				if (returnValue === false) {

					/* 
					 * NOTE: All commands either return the Slidon instance or a JavaScript
					 * object representing some sort of Slidon information requested by the
					 * client which should be returned immediately so client decides what 
					 * to do with it. On some cases were client probably either messed around
					 * with Slidons internal structure or maybe got to send a command to a
					 * Slidon he previously removed from DOM, there won't be an actual Slidon
					 * in DOM to which send this coomand, this is the only scenario where 
					 * false is returned and that's why Slidon gets removed.
					 *
					 **/

					delete slidons[$(this).attr("data-slidon")];
					$(this).removeAttr("data-slidon data-slidon-init");

				} else if (!(returnValue instanceof Slidon)) {

					/* 
					 * NOTE: There are two types of commands Slidons support, those that
					 * change the Slidon current state which can be chained and queued,
					 * and those that return information about the Slidon current state,
					 * the later ones return immediately and break the chain as they
					 * might be used for example from within inside a "Complete" callback
					 * and based on the returned information the client might want to
					 * remove the existing queue or queue new commands based on the
					 * returned information of the current Slidon state.
					 *
					 **/

					return false; // break

				} else {

					returnValue = false;
				}

			} else if ((typeof(options) === "object") || (options === undefined)) {

				/* 
				 * Create a Slidon instance and save it in memory for later
				 * reference is client tries to send any command to it. 
				 *
				 * Slidon will let you initialize the same container only
				 * once as after it was initialized, its internal structure
				 * changed and client probably won't be willing to initialize
				 * the Slidon with this new structure inside it.
				 *
				 **/

				if (($(this).attr("data-slidon") !== undefined) && $(this).children(".slidon-container").length) {
					console.log("Slidon initializing error! Trying to initialize an already initialized Slidon", $(this));
				} else {
					var slidon = new Slidon($(this), options);
					slidons[$(this).attr("data-slidon")] = slidon;
				}
			}
		});

		return (returnValue) ? returnValue : this;
	};

}(jQuery));
