# CeNav
Small plugin for touch menus with jQuery

## About this Plugin
Essentially this plugin allows you to create a touch driven menu system with drop downs.

Technically all this menu is doing is to look for unordered lists with further nesting of unordered lists, signified by a sibling span tag to the adjacent 
nested list.

Upon clicking this span CSS classes will be added to the relevent areas allowing you to style these operations.

## Gettings started
Include the jQuery
```
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>
```

Include CeNav Plugin
```
<script src="jquery.plugin.cenav.1.0.js"></script>
```

Write your menu, something like below:
```
<ul class="top-level">
    <li><a href="#">Page</a></li>
    <li><a href="#">Page</a></li>
    <li><a href="#">Parent <span></span></a>
        <ul class="sub-menu">
            <li><a href="#">Child</a></li>
            <li><a href="#">Child <span></span></a>
                <ul class="sub-menu">
                    <li><a href="#">Grand Child</a></li>
                    <li><a href="#">Grand Child</a></li>
                </ul>
            </li>
            <li><a href="#">Child</a></li>
            <li><a href="#">Child</a></li>
        </ul>
    </li>
    <li><a href="#">Page</a></li>
    <li><a href="#">Page</a></li>
    <li><a href="#">Page</a></li>
</ul>
```

Take **notice** of the **span** tags **adjacent** to nested menus.

Style your menu, and importantly style the utility classes generated by the plugin

```
.active {
    display: block;
}
.close {
    
}
```
## Finally
Initialise the plugin on your top level menu and first level span to look for, from there the plugin will do the rest.

```
$('ul.top-level span').cenav();
```

## Future Versions
I would like to integrate PSEUDO onfocus and PSEUDO offfocus for the menu system but for now you can do this manually.

```
// Maintain focus
$('ul.top-level').on('click', function(e){

    e.stopPropagation();
    
});

// Lose focus
$('html').on('click', function(e){
    
    $('.close, .active').removeClass('close active');

});
```