/*
 *  jquery.tilewall - v0.0.1
 *  A jQuery Plugin for the dynamically positioning of tiles in a responsive grid.
 *  http://martinwilmer.com/tilewall
 *
 *  Made by Martin Wilmer
 *  Under MIT License
 */
!function(a,b,c,d){"use strict";function e(c,d){this.element=c,this.settings=a.extend({},i,d),this._defaults=i,this._name=h,this.init(),this.reformatTiles(),this.reformatTiles();var e=a(b).width();a(b).resize(this.debouncer(function(){a(b).width()!==e&&(e=a(b).width(),g.reformatTiles())},this.settings.debounceTime))}var f,g,h="tileWall",i={debounceTime:100,debug:0,hideNavTilesOnViewportWidthSmallerThan:0,maxNumCols:12,minNumCols:3,minTileWidth:130,shrinkTilesOnViewportWidthSmallerThan:0,tileClassName:"tile",tileMargin:2,transition:0},j={},k=[],l=0,m=0,n=0,o=[];a.extend(e.prototype,{init:function(){if(g=this,this.settings.debug&&this.debugLog("settings:\n"+JSON.stringify(this.settings,null,2)),this.settings.debug&&this.settings.shrinkTilesOnViewportWidthSmallerThan){var a="Automatically shrinking tiles because viewport width is smaller than ";a+=this.settings.shrinkTilesOnViewportWidthSmallerThan+"px disregarding the fix positioning of tiles.",this.debugLog(a)}this.setTileWallPositionRelative()},getTileWallWrapperWidth:function(){var c=a(b).outerWidth(),d=a(this.element).width();return c>d?d:c},calculateNumCols:function(){for(l=this.settings.maxNumCols;(this.getTileWallWrapperWidth()-2*l*this.settings.tileMargin)/l<this.settings.minTileWidth&&(l--,l!==this.settings.minNumCols););},calculateIdealNumRows:function(){m=Math.ceil(n/l)},calculateTileDimensions:function(){j.width=j.height=(this.getTileWallWrapperWidth()-2*l*this.settings.tileMargin)/l},setTileWallPositionRelative:function(){a(this.element).css("position","relative")},setTileWallWrapperHeight:function(){a(this.element).css("height",m*(j.height+2*this.settings.tileMargin)+"px")},setTileDimensions:function(){n=0,k=[];var b,c=1,e=a(this.element).find("."+this.settings.tileClassName),f=this;return 0===e.length&&this.settings.debug?(this.debugLog("No DOM elements with class '"+this.settings.tileClassName+"' to use as tiles found."),!1):void e.each(function(){if(b=a(this),b.data("nav")&&f.settings.hideNavTilesOnViewportWidthSmallerThan&&f.getTileWallWrapperWidth()<f.settings.hideNavTilesOnViewportWidthSmallerThan)return b.css("display","none"),!0;var e=parseInt(b.data("width"))?parseInt(b.data("width")):1,g=parseInt(b.data("height"))?parseInt(b.data("height")):1,h=parseInt(b.data("position-x"))?parseInt(b.data("position-x")):d,i=parseInt(b.data("position-y"))?parseInt(b.data("position-y")):d;f.settings.shrinkTilesOnViewportWidthSmallerThan&&f.getTileWallWrapperWidth()<f.settings.shrinkTilesOnViewportWidthSmallerThan&&(e=1,g=1),b.css("position","absolute"),b.css("display","block"),b.css("width",j.width*e+(e-1)*f.settings.tileMargin*2+"px"),b.css("height",j.height*g+(g-1)*f.settings.tileMargin*2+"px"),b.css("margin",f.settings.tileMargin+"px"),f.settings.transition&&b.css("transition","0.2s ease-out"),k[c]={ref:b,width:e,height:g,size:e*g,priority:b.data("priority")?b.data("priority"):0,positionX:h,positionY:i,nav:b.data("nav")?!0:d},n+=e*g,c++})},sortTilesBySizeAndCurrentness:function(){for(var a=[],b=1;b<k.length;b++)if(k[b].nav===d&&k[b].positionX===d)for(var c=0;c<k.length;c++)if(a[c]===d||k[b].priority>a[c].priority&&k[b].size===a[c].size||k[b].size>a[c].size&&k[b].priority===a[c].priority){a.splice(c,0,k[b]);break}for(b=1;b<k.length;b++)k[b].nav===!0&&k[b].positionX===d&&a.splice(0,0,k[b]);for(b=1;b<k.length;b++)k[b].positionX!==d&&a.splice(0,0,k[b]);var e=[];for(b=0;b<a.length;b++)e[b+1]=a[b];if(k=e,this.settings.debug){for(var f="",g=0;g<a.length;g++)f+="priority: "+a[g].priority+" | ",f+="size: "+a[g].size+" | ",f+="positionX: "+a[g].positionX+" | ",f+="positionY: "+a[g].positionY+" | ",f+="nav: "+a[g].nav+"\n";this.debugLog("sorted tiles:\n"+f)}},reformatTiles:function(){this.calculateNumCols(),this.calculateTileDimensions(),this.setTileDimensions(),this.sortTilesBySizeAndCurrentness(),this.calculateIdealNumRows(),this.setTileWallWrapperHeight(),this.settings.debug&&(this.debugLog("initial overallTileSize: "+n),this.debugLog("initial numRows: "+m),this.debugLog("initial numCols: "+l));var b=0;for(f=!1;!f;)b++,o=this.initTileGridArray(),f=!0,a.each(k,this.placeTile),b>50&&(b=0,m++,this.setTileWallWrapperHeight(),this.settings.debug&&this.debugLog("increased number of rows: "+m));this.settings.debug&&this.debugLog("number of tries to position all tiles properly: "+b)},placeTile:function(b,c){var e,h,i,k,n,p,q;if(0!==b){e=!1,q=0;do{if(q++,q>200){c.ref!==d&&(f=!1);break}if(c.positionX+c.width-1>l&&(c.positionX=d),c.positionX!==d)for(k=[{x:c.positionX,y:c.positionY}],k=g.addTileSurfaceCoordinates(this,k),n=0,p=0;p<k.length;p++)n+=o[k[p].y][k[p].x];else for(h=Math.floor(Math.random()*(l-(c.width-1))+1),i=Math.floor(25>q?Math.random()*(Math.ceil(m/2)-(c.height-1))+1:50>q?Math.random()*(Math.ceil(m/1.6)-(c.height-1))+1:75>q?Math.random()*(Math.ceil(m/1.2)-(c.height-1))+1:Math.random()*(m-(c.height-1))+1),k=[{x:h,y:i}],k=g.addTileSurfaceCoordinates(this,k),n=0,p=0;p<k.length;p++)n+=o[k[p].y][k[p].x];0===n&&(a.each(k,function(){o[this.y][this.x]=b}),c.ref.css("left",(k[0].x-1)*(j.width+2*g.settings.tileMargin)+"px"),c.ref.css("top",(k[0].y-1)*(j.height+2*g.settings.tileMargin)+"px"),e=!0)}while(!e)}},initTileGridArray:function(){o=[];for(var a=1;m>=a;a++){o[a]=[];for(var b=1;l>=b;b++)o[a][b]=0}return o},addTileSurfaceCoordinates:function(a,b){var c,d;if(a.width>1)for(c=b[0].x+1;c<b[0].x+a.width;c++)b.push({y:b[0].y,x:c});if(a.height>1)for(c=b[0].y+1;c<b[0].y+a.height;c++)b.push({y:c,x:b[0].x});if(a.width>1&&a.height>1)for(c=b[0].y+1;c<b[0].y+a.height;c++)for(d=b[0].x+1;d<b[0].x+a.width;d++)b.push({y:c,x:d});return b},debouncer:function(a,b){var c,d=b||200;return function(){var b=this,e=arguments;clearTimeout(c),c=setTimeout(function(){a.apply(b,Array.prototype.slice.call(e))},d)}},debugLog:function(a){console.log("["+this._name+" debug] "+a)}}),a.fn[h]=function(b){return this.each(function(){a.data(this,"plugin_"+h)||a.data(this,"plugin_"+h,new e(this,b))})}}(jQuery,window,document);