(function($) {

	$.fn.gridlayout = function(parameters) {

		var defaultParams = {
			'debug': false,
			'delay': 250,
			'points': {
				'320': {
					'start': null,
					'end': null
				},
				'640': {
					'start': null,
					'end': null
				},
				'768': {
					'start': null,
					'end': null
				},
				'1024': {
					'start': null,
					'end': null
				},
			},
			'timeout': null
		};

		var initialize = function(element) {

			var hasPoints;
			
			if (typeof parameters !== 'object') {
				hasPoints = false;
				parameters = defaultParams;
			} else {
				hasPoints = (typeof parameters['points'] === 'object');
				parameters = $.extend(true, defaultParams, parameters);
			}

			var mediaQueriesTester = document.createElement('div');
			$(mediaQueriesTester).addClass('grid_media_queries_tester')
				.appendTo('body');

			$(window).bind('load', function() {
				var mediaQueriesTesterWidth = $(mediaQueriesTester).width();
				$(mediaQueriesTester).remove();

				if (parameters.debug || mediaQueriesTesterWidth != 1 || hasPoints) {
					var width = $(this).width();
					for (var i in parameters.points) {
						if (Number(i) >= width) {
							$(element).addClass('grid_' + i);
						}
					}

					$(this).bind('resize', function() {
						clearTimeout(parameters.timeout);
						parameters.timeout = setTimeout(function() {
							var width = $(window).width();
							for (var i in parameters.points) {
								var p = parameters.points[i];

								if (Number(i) < width) {
									$(element).removeClass('grid_' + i);
									if (typeof p.end == 'function') {
										p.end(width);
									}

								} else {
									$(element).addClass('grid_' + i);
									if (typeof p.start == 'function') {
										p.start(width);
									}
								}
							}
						}, parameters.delay);
					}).trigger('resize');
				}
			});
		};

		/*****************************************
		 * JQuery Loop
		 *****************************************/

		this.each(function() {
			initialize(this);
		})

		return this;
	};

})(jQuery);