# jQuery Masonry plugin

## Demo

http://github.indyworks.ru/indymasonry/

## Installation

Include script *after* the jQuery library:

```html
<script src="/path/to/jquery.indyMasonry.js"></script>
```

### HTML

```html
<section class="indy-masonry-container">
    <figure class="indy-masonry">
        <img src="img/1.jpg" alt="">
    </figure>
    <figure class="indy-masonry">
        <img src="img/2.jpg" alt="">
    </figure>
    <figure class="indy-masonry">
        <img src="img/3.jpg" alt="">
    </figure>
    ...
</section>
```

### jQuery

Use the plugin *after* window load as follows:

```js
$(window).on('load', function() {

	$('indy-masonry-container').indyMasonry({

		'column' 		: 4,	/// column count,  default = 4
		'gap' 			: 20,	/// column gap,    default = 20
		'mTop'			: 10,	/// margin-top,    default = 10
		'mBottom'		: 10,	/// margin-bottom, default = 10
		
	});

});
```
#### Add new elements

Just call '_newElement' method *after* new images load:

```js
	$('indy-masonry-container').indyMasonry('_newElement');
```


## License

This plugin is available under [the MIT license](http://mths.be/mit).
