# jQuery Tab Complete

Tab Completion for jQuery. Tab-complete allows developers to specify a list of options to be auto completed when typing in the binded input. Words can be auto completed from anywhere within the text input, the beginning, middle, or end.


*What makes this plugin different from the others?*

The major feature that this tab completion plugin has is that you are able to tab complete any word, not only last word in the input. Ever needed to go back and insert a word in the middle of a sentence, but needed to auto-complete it? Well, this plugin allows you to do just that!

## Installation

You can run:

```bower install tab-complete```

```npm install tab-complete```

or manually copy the tab-complete files to your project.

Installing tab-complete via NPM will install [TrieJS](https://github.com/pthurlow/triejs) as a module for you.

## Usage

Include [TrieJS](https://github.com/pthurlow/triejs), jQuery, and Tab-Complete

```
<script src="jquery.min.js"></script>
<script src="trie.min.js"></script>
<script src="jquery.tab-complete.js"></script>
```

```
$("#example-input").tabComplete({
	getOptions: function() {
		return ["John", "Jake", "Joe", "Sam", "Gil", "Ken", "Garret"];
	},
	getFormat: function(word, position) {
		if (position === 0) {
			return word + ": ";
		} else {
			return word;
		}
	},
	select: true
});
```

The *getOptions()* function should return an array of options that will be auto-completed.

The *getFormat()* function returns the format of the new word, based on the "word" and "position" parameters.

The *select* property determines whether or not the auto completed text will be selected when auto-completed.

You can also add, remove, and reset the options to be auto completed:

```
$("#example-input").tabComplete("add", ["Johnathan"]);
$("#example-input").tabComplete("remove", ["John"]);
$("#example-input").tabComplete("reset", ["Ava", "Daniel", "Matt"]);
```

The first option specifies the method to use, and the second option is an array of items to be added or removed. In the case of the reset method, the word list is emptied, and the items in the optional array are added to the new list.