(function($) {
  $.fn.tabComplete = function(options, items) {
    // here we handle the changes to the trie structure,
    // allowing it to be manipulated dynamically
    if (typeof(options) === "string") {
      if (options === "add") {
        var trie = $(this).data('trie');
        for (var i = 0; i < items.length; i++) {
          trie.add(items[i]);
        }
        $(this).data('trie', trie);
      } else if (options === "remove") {
        var trie = $(this).data('trie');
        for (var i = 0; i < items.length; i++) {
          console.log("Removing: ", items[i])
          trie.remove(items[i]);
        }
        $(this).data('trie', trie);
      } else if (options === "reset") {
        var trie = new Triejs();
        if (items) {
          for (var i = 0; i < items.length; i++) {
            trie.add(items[i]);
          }
        }
        $(this).data('trie', trie);
      }
      return;
    }
    /*
      getOptions(): Returns an array of auto-complete words
      getFormat(word, position): Returns the format that the new word should use. Params are the word in question, and the position of it in the sentence.
      select: Whether or not the auto-completed text should be highlighted when tabbing through the options.
      preventTabbing: Whether or not the plugin should prevent tabbing between inputs, even when there are no words to auto-complete.
    */
    var defaults = {
      getOptions: function() {
        console.warn("Options for tab-complete not specified.");
        return [];
      },
      select: true,
      preventTabbing: false
    };
    var options = $.extend(defaults, options);
    var trie = $(this).data('trie') || new Triejs();
    var completers = options.getOptions();
    for (var i = 0; i < completers.length; i++) {
      trie.add(completers[i]);
    }
    $(this).data('trie', trie);
    var index = 0;
    var val;
    var words;
    var word;
    var saved = false;
    var possible;
    var position;
    var wordPos;
    $(this).keydown(function(e) {
      if (e.keyCode === 9) {
        trie = $(this).data('trie');
        if (!saved) {
          position = $(this).getCursorPosition();
          val = $(this).val();

          words = val.split(" ");
          var lcount = 0;
          for (var i = 0; i < words.length; i++) {
            var w = words[i];
            lcount += w.length + 1;
            if (lcount >= position) {
              word = words[i];
              wordPos = i;
              break;
            }
          };

          saved = true;
          possible = trie.find(word);

        } else {
          index++;
        }
        if (possible && index >= possible.length) {
          index = 0;
        }
        if (possible) {
          e.preventDefault();
          var dupe = words;
          if (typeof(options.getFormat) === "function") {
            dupe[wordPos] = options.getFormat(possible[index], wordPos);
          } else {
            dupe[wordPos] = possible[index];
          }
          if (typeof(options.onComplete) === "function") {
            options.onComplete(word, possible, possible[index]);
          }
          var newPos = words.slice(0, wordPos + 1).join(" ").length;
          $(this).val(words.join(" "));
          if (options.select) {
            $(this).selectRange((newPos - (dupe[wordPos].length - word.length)), newPos);
          } else {
            $(this).selectRange(newPos);
          }
        }
        if (options.preventTabbing) {
          e.preventDefault();
        }
      } else {
        saved = false;
        index = 0;
      }
    });
    $(this).click(function(){
      saved = false;
      index = 0;
    });
  };

  $.fn.selectRange = function(start, end) {
    if(!end) end = start; 
    return this.each(function() {
      if (this.setSelectionRange) {
        this.focus();
        this.setSelectionRange(start, end);
      } else if (this.createTextRange) {
        var range = this.createTextRange();
        range.collapse(true);
        range.moveEnd('character', end);
        range.moveStart('character', start);
        range.select();
      }
    });
  };

  $.fn.getCursorPosition = function() {
    var el = $(this).get(0);
    var pos = 0;
    if ('selectionStart' in el) {
      pos = el.selectionStart;
    } else if ('selection' in document) {
      el.focus();
      var Sel = document.selection.createRange();
      var SelLength = document.selection.createRange().text.length;
      Sel.moveStart('character', -el.value.length);
      pos = Sel.text.length - SelLength;
    }
    return pos;
  };
}(jQuery));