rsModal
=======

Why make another jQuery modal plugin? All you need to do is Google, "jQuery Modal Plugin" You will find so many of them! While I do tend to make use of a few of these, I always prefer to make my own plugin. You learn more by doing things yourself! Here is my learning curve with this plugin.

**Installation**
--
```
npm install rsmodal
```

**Usage**
--

After including jQuery and the rsModal plugin, instantiate rsModal like so:

```javascript
$(function(){
    $('.myModal').click(function(){
      $('#modalcontent').rsModal();
    });
});
```

```html
<button class="myModal">Open Modal</button>
<div id="modalcontent" style="display:none;">
    This is the content that will appear inside the modal
</div>
```

**Testing**
--
Tested on IE8+, Firefox 3.6+, Chrome 15+, Opera 12.5+, Safari 4+

**Options**
--
<table class="table">
    <tbody>
        <tr>
            <th>option</th>
            <th>description</th>
            <th>default</th>
            <th>type</th>
        </tr>
        <tr>
            <td>background</td>
            <td>Background colour of the modal window</td>
            <td>#FFF</td>
            <td>string</td>
         </tr>
         <tr>
            <td>bodyColor</td>
            <td>text colour of the modal main body</td>
            <td>#555</td>
            <td>string</td>
         </tr>
         <tr>
            <td>closeColor</td>
            <td>text colour of the modal close button</td>
            <td>#555</td>
            <td>string</td>
         </tr>
         <tr>
            <td>titleColor</td>
            <td>text colour of the modal title</td>
            <td>#555</td>
            <td>string</td>
         </tr>
        <tr>
            <td>height</td>
            <td>Height of the modal</td>
            <td>323px</td>
            <td>string</td>
        </tr>
        <tr>
            <td>width</td>
            <td>Width of the modal</td>
            <td>500px</td>
            <td>string</td>
        </tr>  
        <tr>
            <td>padding</td>
            <td>Padding of the main content of the modal</td>
            <td>20</td>
            <td>int</td>
        </tr> 
        <tr>
            <td>title</td>
            <td>Title of the modal</td>
            <td>rsModal</td>
            <td>string</td>
        </tr>
    </tbody>
</table>

**Demo**
--
Click <a href="http://www.rstandley.co.uk/rsmodal-jquery-modal/" target="_blank">here</a> to view a demo