SmartFields
====
SmartFields is a simple jQuery plugin which is used to make your inputs and textareas a little nicer. [Live preview](http://codepen.io/_jsmth/full/pvONrE/), feel free to have a play!

#How to use
Installing and using SmartFields couldn't be easier, you simply add the smartFields.js file into your document after you include jQuery and you're ready to go! Simply just call the smartFields plugin onto your element.
```javascript
$(function(){
  $('input, textarea').smartField();
});
```

#Options
You have a few options as well with this plugin! I thought I'd be nice and throw in some for you.

 - Callbacks
 	- **focus** - When you focus an element you can run a function which will execute some of your own code.

  - **blur** - When you blur an element you can also run a function containing some of your own code.
 - **showLogs**
 	- This is set to false by default, but when set to true, it will allow you to see some logs which I threw around the place to make it easier to debug.

 - **className**
 	- This is the name you want your main "smart field" container to be by default it is set to 'smart-field'

 - **threshold**
 	- While making this plugin I realised that there where some placeholders which you may have which are just way to long to fit along side. So this threshold sets the max width (in percentage) the input can be before the placeholder is animated above the input. Default is set to 60

 - **placeholderAttrName**
 	- This is so that if you didn't want to use the placeholder attribute, but another attribute instead for example "data-placeholder" you can do so, you may want to do this to keep the use of the placeholder.

 - **data-placeholderReplace**
  - This is applied to the input itself as a data attribute, and it allows you to change the placeholder on focus. If you have too long of an placeholder you may want to simplify it on focus!


```javascript
$(function(){
  $('input, textarea').smartField({
     className: 'smart-field',
     showLogs: false,
     threshold: 60,
     placeholderAttrName: 'placeholder',
     focus: function() {
     	//focus callback
     },
	 blur: function() {
     	//blur callback
     },
  });
});
```
