(function ($) {

	//Initiate the plugin
	$.fn.smartField = function(options) {

		//Set the default settings of the plugin
	    var settings = $.extend({
	    	className: 'smart-field',
	    	placeholderAttrName: 'placeholder',
	    	threshold: 60,
	    	showLogs: false,
	        focus: function() {},
	        blur: function() {},
	    }, options);

	    //For each element which this applies to.
	    return this.each(function() {
	        var $element = $(this);
	        var smallTextPadding = 10;

	        //Check if the element is supported
	        if($element.is('input') || $element.is('textarea')) {
	        	//Create the smartfield container
	        	var $smartField = $("<div>", {
		        	class: settings.className,
		        	role: 'input'
		        }).insertBefore($element);

		        if($element.is('textarea')) {
		        	$smartField.addClass('textarea');
		        }

	        	//Create the placeholder container
           		var $placeholder = $("<span>", {
		        	class: 'placeholder',
		        	role: 'placeholder'
		        }).appendTo($smartField);

	            if($element.attr('data-placeholderReplace') != undefined) {
	              $placeholder.text($element.attr('data-placeholderReplace'));
	            }else{
	              $placeholder.text($element.attr(settings.placeholderAttrName));
	            }

		        //Calculate the size of the input
		        var difference = parseInt($smartField.outerWidth() - $placeholder.outerWidth());
		        var size = parseInt(difference/$smartField.outerWidth() * 100);

		        //Set the size of the input correctly
		        $element.css('width', 'calc(' + size + '% - ' + (parseInt($smartField.css('paddingLeft')) * 3) + 'px)');
		        $element.css('width', '-webkit-calc(' + size + '% - ' + (parseInt($smartField.css('paddingLeft')) * 3) + 'px)');

		        //If you have the logs setting to true
		        if(settings.showLogs) {
		        	console.log('Input size was set to: ' + size + '%');
		        }

	        	$element.prependTo($smartField); //Place the originial input within the smart field container
	            $placeholder.text($element.attr(settings.placeholderAttrName));
	            $placeholder.attr('data-oldPlaceholder', $element.attr(settings.placeholderAttrName));
		        $element.removeAttr(settings.placeholderAttrName); //Remove the placeholder attr used to make the placeholder text

		        //If you have the logs setting to true
		        if(settings.showLogs) {
		        	console.log('SmartField was created.');
		        }

		        $smartField.on('click', function() {
		        	var $thisSmartField = $(this);
		        	$thisSmartField.addClass('visible focused');
		        	$thisSmartField.find(":first-child").focus();

					if($element.attr('data-placeholderReplace') != undefined) {
						$placeholder.text($thisSmartField.find(":first-child").attr('data-placeholderReplace'));
					}else{
						$placeholder.text($thisSmartField.find(":first-child").attr('data-placeholderOld'));
					}

		        	if(size > settings.threshold) {
	        			$thisSmartField.find('.placeholder').css('left',  'calc(' + size + '% - ' + parseInt($smartField.css('paddingLeft')) + 'px)');
	        			$thisSmartField.find('.placeholder').css('left',  '-webkit-calc(' + size + '% - ' + parseInt($smartField.css('paddingLeft')) + 'px)');

		        	} else {
		        		$thisSmartField.css('marginTop', parseInt($placeholder.outerHeight() + (smallTextPadding * 2)) + 'px');
		        		$thisSmartField.find('.placeholder').css('left',  '0px');
		        		$thisSmartField.find('.placeholder').css('top',  '-' + parseInt($placeholder.outerHeight() + smallTextPadding) + 'px');
		        		$placeholder.addClass('small');
		        		$smartField.find(":first-child").css('width', 'calc(100% - ' + (parseInt($smartField.css('paddingLeft')) * 2) + 'px)');
		        		$smartField.find(":first-child").css('width', '-webkit-calc(100% - ' + (parseInt($smartField.css('paddingLeft')) * 2) + 'px)');
		        	}


		        	settings.focus.call(this); //run the focus callback

		        	//If you have the logs setting to true
			        if(settings.showLogs) {
			        	console.log('SmartField was focused.');
			        }
		        });

		        $smartField.find(":first-child").on('blur', function() {
		        	var $inputField = $(this);
		        	var $thisSmartField = $inputField.parent();

		        	if($inputField.val() != '') {
		        		$thisSmartField.removeClass('focused');
		        	}else{
		        		if(size > settings.threshold) {
		        			$thisSmartField.removeClass('focused visible');
		        			$thisSmartField.find('.placeholder').css('left', parseInt($smartField.css('paddingLeft')) + 'px');
		        		}else{
		        			$thisSmartField.removeClass('focused visible');
		        			$thisSmartField.css('marginTop', 0);
		        			$thisSmartField.find('.placeholder').css('left',  parseInt($smartField.css('paddingLeft')) + 'px');
			        		$thisSmartField.find('.placeholder').css('top',  parseInt($smartField.css('paddingTop')) + 'px');
			        		$thisSmartField.find('.placeholder').removeClass('small');
		        		}

						setTimeout(function() {
							$thisSmartField.find('.placeholder').text($thisSmartField.find('.placeholder').attr('data-oldplaceholder'));
						}, 300);
		        	}

		        	settings.blur.call(this); //run the focus callback

		        	//If you have the logs setting to true
			        if(settings.showLogs) {
			        	console.log('SmartField was blured.');
			        }
		        });

	        }else{
	        	//If the element is not supported
	        	if(settings.showLogs) {
	        		console.log('Error: The element you have attached smart fields to was not supported. Sorry!');
	        	}
	        }
	    });
	};
}(jQuery));