# jQuery Auto Table Numbers PLUGIN

A Lightweight jQuery Plugin That Automatically Numbers Table Rows — With OPTIONAL **BOLD Styling**, **Leading Zeros** & Full Customization.

---

## ✨ FEATURES :
- 🔢 Auto Number Table Rows Dynamically
- 🚀 Supports Tables With `thead`, `tbody`, ETC.
- 💪 Option To Display Numbers In **BOLD**
- 💪 Option To Display Numbers With **Zero**
- 🧩 Works Even If Rows Are Filtered Or Hidden (`:VISIBLE`)
- ⚡ Simple To Use, No Dependencies (Except jQuery!)

---

## 📦 INSTALLATION :

### 🔹 OPTION `01` — via CDN (✅RECOMMENDED)
Add These Lines To Your HTML File:

```html
<!-- MINIFIED Version (RECOMMENDED) -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/gh/arasheb0098/autotablenumbers/jquery.AutoTableNumbers.min.js"></script>
```
OR
```html
<!-- FULL Version (Useful For Development & Debugging) -->
<script src="https://code.jquery.com/jquery-3.7.1.js"></script>
<script src="https://cdn.jsdelivr.net/gh/arasheb0098/autotablenumbers/jquery.AutoTableNumbers.js"></script>
```
---

### 🔹 OPTION `02` — via NPM
Run The Build Script Command:
```html
npm install jquery-autotablenumbers
```
Then, Simply Import:
```html
import 'jquery-autotablenumbers';
$('table').AutoTableNumbers();
```

---

## 🧠 USAGE EXAMPLE :

```html
/* HTML */
<table id="MyTable" border="1" cellpadding="5">
	<thead>
		<tr><th>#</th><th>Name</th><th>City</th></tr>
	</thead>
	<tbody>
		<tr><td></td><td>Ali</td><td>Tehran</td></tr>
		<tr><td></td><td>Maryam</td><td>Isfahan</td></tr>
		<tr><td></td><td>Reza</td><td>Mashhad</td></tr>
	</tbody>
</table>
```
```html
/* JS */
<script>
$(document).ready(function () {
	// Simple Numbering:
	$('#MyTable').AutoTableNumbers();
	
	// ------------ OR --------------
	
	// With Options:
	$('#MyTable').AutoTableNumbers({
		column: 0,  // Which Column To Place Numbers (0 = First Column)
		start: 1,   // Starting Number
		bold: true, // Display Numbers In BOLD
		zero: true  // Display Numbers With Zero
	});
});
</script>
```

---

## ⚙️ OPTIONS :

| OPTION     | TYPE    | DEFAULT              | DESCRIPTION                          |
| ---------- | ------- | -------------------- | ------------------------------------ |
| `column`   | Number  | `0`                  | Column Index Where Numbers Are Shown |
| `start`    | Number  | `1`                  | Starting Number                      |
| `selector` | String  | `'tbody tr:visible'` | Which Rows To Number                 |
| `bold`     | Boolean | `false`              | Display Numbers In BOLD IF `true`    |
| `zero`     | Boolean | `false`              | Display Numbers With Zero IF `true`  |

---

## 📜 LICENSE :
MIT License © [ArAsH](https://github.com/arasheb0098)