/**
 * jQuery Auto Table Numbers PLUGIN V1.0.0
 * ---------------------------------------
 * Automatically Numbers Table Rows With Optional "Bold Styling" & "Leading Zeros"
 *
 * USAGE:
 *   $('#MyTable').AutoTableNumbers();
 *   -------------- OR --------------
 *   $('#MyTable').AutoTableNumbers({ column: 1, start: 10, bold: true, zero: true });
 *
 * OPTIONS:
 *   column      - Index Of The Column To Display Row Numbers (DEFAULT: 0)
 *   start       - Starting Number (DEFAULT: 1)
 *   selector    - Row Selector (DEFAULT: 'tbody tr:visible')
 *   bold        - IF TRUE, Numbers Will Be BOLD (DEFAULT: FALSE)
 *   zero        - IF TRUE, Adds Zero To Single-Digit Numbers (DEFAULT: FALSE)
 *
 * AUTHOR: ArAsH
 * LICENSE: MIT
 */

(function ($) {
	$.fn.AutoTableNumbers = function (OPTIONS) {
		// DEFAULT Settings
		var Settings = $.extend({
			column: 0,
			start: 1,
			selector: 'tbody tr:visible',
			bold: false, // IF TRUE, Numbers Will Be BOLD
			zero: false  // IF TRUE, Adds Zero To Single-Digit Numbers
		}, OPTIONS);

		return this.each(function () {
			var $Table = $(this);
			var $Rows = $Table.find(Settings.selector);

			$Rows.each(function (INDEX) {
				var $CurrentNumber = Settings.start + INDEX;
				var $Cell = $(this).find('td').eq(Settings.column);
				var $DisplayNumber;

				// Add Leading Zero, IF ENABLED
				if (Settings.zero && $CurrentNumber < 10) {
					$DisplayNumber = '0' + $CurrentNumber;
				} else {
					$DisplayNumber = $CurrentNumber;
				}

				// Apply BOLD Styling, IF ENABLED
				if (Settings.bold) {
					$Cell.html('<b>' + $DisplayNumber + '</b>');
				} else {
					$Cell.text($DisplayNumber);
				}
			});
		});
	};
})(jQuery);