$(document).ready(function () {
    let pluginEnabled = true;

    function initializePlugin() {
        // Default
        $('#table-default').AutoTableNumbers();

        // With bold and zero options
        $('#table-bold-zero').AutoTableNumbers({
            bold: true,
            zero: true
        });

        // With column and start options
        $('#table-column-start').AutoTableNumbers({
            column: 1,
            start: 100
        });
    }

    function destroyPlugin() {
        // Clear table cells
        $('#table-default tbody tr').each(function() {
            $(this).find('td').eq(0).empty();
        });
        $('#table-bold-zero tbody tr').each(function() {
            $(this).find('td').eq(0).empty();
        });
        $('#table-column-start tbody tr').each(function() {
            $(this).find('td').eq(1).empty();
        });
    }

    // Initial load
    initializePlugin();

    $('#togglePlugin').on('click', function() {
        pluginEnabled = !pluginEnabled;
        if (pluginEnabled) {
            initializePlugin();
            $(this).text('Disable Plugin').removeClass('enabled');
        } else {
            destroyPlugin();
            $(this).text('Enable Plugin').addClass('enabled');
        }
    });
});