# BsAlert

jQuery plugin for Bootstrap alerts manipulation.

## Requirements

* [jQuery](https://jquery.com/) ver. 3.6.0+
* [Bootstrap](https://getbootstrap.com/) ver. 5.1.3+

## Installation

Simply add `jquery.bs.alert.min.js` at the bottom of your page, after jQuery and Bootstrap's JS:

```html
<!doctype html>
<html>
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="bootstrap.min.css">
  </head>
  <body>
    <!-- jQuery -->
    <script src="jquery.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="bootstrap.bundle.min.js"></script>
    <!-- BsAlert -->
    <script src="jquery.bs.alert.min.js"></script>
  </body>
</html>
```

## Settings

### Parameters

| Value | Type | Description | Default | Obligatory
| --- | --- | --- | --- | --- |
| `type` | String | Specify the alert's type. See [Bootstrap's default types](https://getbootstrap.com/docs/5.1/components/alerts/#examples) or create your own alert-${type} class. | `null` | Yes |
| `dismissible` | Boolean | If enabled, the alert will have a close button within itself that will allow you to dismiss it. Said button will trigger the alert's `onDismiss` callback, provided the `fadeout` parameter is set to `false`. | `true` | No |
| `icon` | String | You can pass a custom class for an icon that will be placed at the start of the alert's content (e.g. `bi bi-exclamation-lg`). | `null` | No |
| `heading` | String | This will render a properly formatted title/heading in your alert. | `null` | Only if `content` is not passed. |
| `content` | String | Your alert's actual message. | `null` | Only if `heading` is not passed. |
| `fadeout` | Boolean | Make your alert automatically disappear in 5 seconds. | `true` | No |
| `duration` | Number | If your alert(s) is/are set to automatically disappear, this value represent how many seconds they'll stay on your page. | `5` | No |
| `clear` | Boolean | When this is set to `true`, the alert container will be totally cleared before creating the new alert. This will not trigger any `onDismiss` callback. | `true` | No |

### Callbacks

| Value | Type | Description | Default | Obligatory
| --- | --- | --- | --- | --- |
| `onShow` | Function | Specify what happens when your alert appears in your page. | `{}` | No |
| `onDismiss` | Function | Specify what happens when the alert leaves your page. | `{}` | No |

```js
$('#alert-container').bsAlert({
  // ...
  onShow: function() {
    // Do something...
  },

  onDismiss: function() {
    // Do something else...
  },
});
```

# Overriding defaults

You can override BsAlert's default settings by adding them to the top of your script as follows:

```js
$.fn.bsAlert.defaults.type = 'primary';
$.fn.bsAlert.defaults.dismissible = false;
$.fn.bsAlert.defaults.fadeout = false;
$.fn.bsAlert.defaults.clear = false;
// ...

$.fn.bsAlert.defaults.onShow = function() {
  // ...
};

$.fn.bsAlert.defaults.onDismiss = function() {
  // ...
};
```

# Usage example

```js
$('#alert-wrapper').bsAlert({
  type: 'success',
  heading: 'Task completed!',
  content: 'No errors found. <a href="/">Return to the homepage</a>.',
  icon: 'bi bi-check-lg',
  fadeout: false,

  onShow: function() {
    console.log('Alert created!');
  },

  onDismiss: function() {
    console.log('Alert closed!');
  },
});
```

```html
<div id="alert-wrapper">
  <div role="alert" class="alert alert-success alert-dismissible fade show">
    <h4 class="alert-heading">Task completed!</h4>
    <hr>
    <p class="mb-0">
      <i class="bi bi-check-lg me-1"></i>
      No errors found. <a href="/" class="alert-link">Return to the homepage</a>.
    </p>
    <button type="button" data-bs-dismiss="alert" aria-label="Dismiss" title="Dismiss" class="btn-close"></button>
  </div>
</div>
```

## Public methods

### Remove

You can remove the most recently added alert to your target wrapper by calling the `remove` method passing it as an argument:

```js
$('#alert-wrapper').bsAlert('remove');
```

This will start removing from the top alert and will alyways trigger its `onDismiss` callback.

Please note that this will **not** remove the alerts that have the `fadeout` parameter set to `true`, since those will remove themselves.

# License

Licensed under the [MIT license](LICENSE.md).
