const TOAST_CONTAINER=document.createElement("div");TOAST_CONTAINER.id="toastContainer",TOAST_CONTAINER.className="toast-container position-fixed top-0 end-0",TOAST_CONTAINER.setAttribute("aria-live","polite"),document.body.appendChild(TOAST_CONTAINER);const TOAST_TEMPLATE=document.createElement("div");var TOAST_STATUS,TOAST_PLACEMENT,TOAST_THEME,TOAST_TIMERS;TOAST_TEMPLATE.className="toast",TOAST_TEMPLATE.setAttribute("role","status"),TOAST_TEMPLATE.setAttribute("aria-live","polite"),TOAST_TEMPLATE.setAttribute("aria-atomic","true"),TOAST_TEMPLATE.setAttribute("data-bs-autohide","false"),TOAST_TEMPLATE.innerHTML='\n        <div class="toast-header">\n            <span class="status-icon bi me-2" aria-hidden="true"></span>\n            <strong class="me-auto toast-title"></strong>\n            <small class="timer" aria-hidden="true"></small>\n            <button type="button" class="btn-close ms-2" data-bs-dismiss="toast" aria-label="Close"></button>\n        </div>\n        <div class="toast-body"></div>',function(TOAST_STATUS){TOAST_STATUS[TOAST_STATUS.SUCCESS=1]="SUCCESS",TOAST_STATUS[TOAST_STATUS.DANGER=2]="DANGER",TOAST_STATUS[TOAST_STATUS.WARNING=3]="WARNING",TOAST_STATUS[TOAST_STATUS.INFO=4]="INFO"}(TOAST_STATUS||(TOAST_STATUS={})),function(TOAST_PLACEMENT){TOAST_PLACEMENT[TOAST_PLACEMENT.TOP_LEFT=1]="TOP_LEFT",TOAST_PLACEMENT[TOAST_PLACEMENT.TOP_CENTER=2]="TOP_CENTER",TOAST_PLACEMENT[TOAST_PLACEMENT.TOP_RIGHT=3]="TOP_RIGHT",TOAST_PLACEMENT[TOAST_PLACEMENT.MIDDLE_LEFT=4]="MIDDLE_LEFT",TOAST_PLACEMENT[TOAST_PLACEMENT.MIDDLE_CENTER=5]="MIDDLE_CENTER",TOAST_PLACEMENT[TOAST_PLACEMENT.MIDDLE_RIGHT=6]="MIDDLE_RIGHT",TOAST_PLACEMENT[TOAST_PLACEMENT.BOTTOM_LEFT=7]="BOTTOM_LEFT",TOAST_PLACEMENT[TOAST_PLACEMENT.BOTTOM_CENTER=8]="BOTTOM_CENTER",TOAST_PLACEMENT[TOAST_PLACEMENT.BOTTOM_RIGHT=9]="BOTTOM_RIGHT"}(TOAST_PLACEMENT||(TOAST_PLACEMENT={})),function(TOAST_THEME){TOAST_THEME[TOAST_THEME.LIGHT=1]="LIGHT",TOAST_THEME[TOAST_THEME.DARK=2]="DARK"}(TOAST_THEME||(TOAST_THEME={})),function(TOAST_TIMERS){TOAST_TIMERS[TOAST_TIMERS.DISABLED=0]="DISABLED",TOAST_TIMERS[TOAST_TIMERS.ELAPSED=1]="ELAPSED",TOAST_TIMERS[TOAST_TIMERS.COUNTDOWN=2]="COUNTDOWN"}(TOAST_TIMERS||(TOAST_TIMERS={}));class Toast{static configure(options){this.setMaxCount(null==options?void 0:options.maxToasts),this.setPlacement(null==options?void 0:options.placement),this.setTheme(null==options?void 0:options.theme),this.enableTimers(null==options?void 0:options.enableTimers),this.enableQueue(null==options?void 0:options.enableQueue)}static setMaxCount(maxToasts){null!==maxToasts&&(maxToasts>0?this.maxToastCount=maxToasts:console.error("The maximum number of toasts must be greater than 0. Reverting to default."))}static setPlacement(placement){switch(TOAST_CONTAINER.className="toast-container position-fixed",placement){case TOAST_PLACEMENT.TOP_LEFT:TOAST_CONTAINER.classList.add("top-0","start-0");break;case TOAST_PLACEMENT.TOP_CENTER:TOAST_CONTAINER.classList.add("top-0","start-50","translate-middle-x");break;case TOAST_PLACEMENT.TOP_RIGHT:TOAST_CONTAINER.classList.add("top-0","end-0");break;case TOAST_PLACEMENT.MIDDLE_LEFT:TOAST_CONTAINER.classList.add("top-50","start-0","translate-middle-y");break;case TOAST_PLACEMENT.MIDDLE_CENTER:TOAST_CONTAINER.classList.add("top-50","start-50","translate-middle");break;case TOAST_PLACEMENT.MIDDLE_RIGHT:TOAST_CONTAINER.classList.add("top-50","end-0","translate-middle-y");break;case TOAST_PLACEMENT.BOTTOM_LEFT:TOAST_CONTAINER.classList.add("bottom-0","start-0");break;case TOAST_PLACEMENT.BOTTOM_CENTER:TOAST_CONTAINER.classList.add("bottom-0","start-50","translate-middle-x");break;case TOAST_PLACEMENT.BOTTOM_RIGHT:TOAST_CONTAINER.classList.add("bottom-0","end-0");break;default:TOAST_CONTAINER.classList.add("top-0","end-0")}}static setTheme(theme=null){let header=TOAST_TEMPLATE.querySelector(".toast-header"),close=header.querySelector(".btn-close");switch(theme){case TOAST_THEME.LIGHT:TOAST_TEMPLATE.style.backgroundColor="var(--body-bg-color-light)",TOAST_TEMPLATE.style.color="var(--text-color-light)",header.style.backgroundColor="var(--header-bg-color-light)",header.style.color="var(--header-color-light)",close.style.filter="unset";break;case TOAST_THEME.DARK:TOAST_TEMPLATE.style.backgroundColor="var(--body-bg-color-dark)",TOAST_TEMPLATE.style.color="var(--text-color-dark)",header.style.backgroundColor="var(--header-bg-color-dark)",header.style.color="var(--header-color-dark)",close.style.filter="invert(1) grayscale(100%) brightness(200%)";break;default:TOAST_TEMPLATE.removeAttribute("style"),header.removeAttribute("style"),close.removeAttribute("style")}}static enableTimers(type){this.timersEnabled=type}static enableQueue(enabled=!0){this.queueEnabled=enabled,enabled||(this.queue=[])}static create(toastOptions){let toastEl=TOAST_TEMPLATE.cloneNode(!0),toastTitle,toastBody;if(toastEl.querySelector(".toast-title").innerText=toastOptions.title,toastEl.querySelector(".toast-body").innerHTML=toastOptions.message,this.setStatus(toastEl,toastOptions.status),this.currentToastCount>=this.maxToastCount){if(!this.queueEnabled)return;const toastToQueue={toast:toastEl,timeout:toastOptions.timeout};return void this.queue.push(toastToQueue)}const toastInfo={toast:toastEl,timeout:toastOptions.timeout};this.render(toastInfo)}static setStatus(toastEl,status){let statusIcon=toastEl.querySelector(".status-icon");switch(status){case TOAST_STATUS.SUCCESS:statusIcon.classList.add("text-success","bi-check-circle-fill");break;case TOAST_STATUS.DANGER:statusIcon.classList.add("text-danger","bi-x-circle-fill"),toastEl.setAttribute("role","alert"),toastEl.setAttribute("aria-live","assertive");break;case TOAST_STATUS.WARNING:statusIcon.classList.add("text-warning","bi-exclamation-circle-fill"),toastEl.setAttribute("role","alert"),toastEl.setAttribute("aria-live","assertive");break;case TOAST_STATUS.INFO:statusIcon.classList.add("text-info","bi-info-circle-fill");break;default:statusIcon.classList.add("d-none")}}static render(toastInfo){toastInfo.timeout>0&&(toastInfo.toast.setAttribute("data-bs-delay",toastInfo.timeout.toString()),toastInfo.toast.setAttribute("data-bs-autohide","true")),this.renderTimer(toastInfo),TOAST_CONTAINER.appendChild(toastInfo.toast);const bsToast=new window.bootstrap.Toast(toastInfo.toast);bsToast.show(),this.currentToastCount++,toastInfo.toast.addEventListener("hidden.bs.toast",()=>{if(TOAST_CONTAINER.removeChild(toastInfo.toast),this.currentToastCount--,this.queueEnabled&&this.queue.length>0&&this.currentToastCount<this.maxToastCount){const queuedToast=this.queue.shift();this.render(queuedToast)}})}static renderTimer(toastInfo){let timer=toastInfo.toast.querySelector(".timer");switch(this.timersEnabled){case TOAST_TIMERS.ELAPSED:{timer.innerText="just now";let minutes=1,elapsedTimer=setInterval(()=>{timer.innerText=`${minutes}m ago`,minutes++},6e4);toastInfo.toast.addEventListener("hidden.bs.toast",()=>{clearInterval(elapsedTimer)});break}case TOAST_TIMERS.COUNTDOWN:if(toastInfo.timeout>0){let seconds=toastInfo.timeout/1e3;timer.innerText=`${seconds}s`;let countdownTimer=setInterval(()=>{timer.innerText=`${seconds-1}s`,seconds--},1e3);toastInfo.toast.addEventListener("hidden.bs.toast",()=>{clearInterval(countdownTimer)});break}default:{let toastHeader;toastInfo.toast.querySelector(".toast-header").removeChild(timer);break}}}static oldConfigure(maxToasts=null,placement=TOAST_PLACEMENT.TOP_RIGHT,theme=null,enableTimers=!0){const configuration={maxToasts:maxToasts,placement:placement,theme:theme,enableTimers:enableTimers?TOAST_TIMERS.ELAPSED:TOAST_TIMERS.DISABLED};this.configure(configuration)}static oldCreate(title,message,status=0,timeout=0){const toast={title:title,message:message,status:status,timeout:timeout};this.create(toast)}static oldEnableTimers(enabled){this.timersEnabled=enabled?TOAST_TIMERS.ELAPSED:TOAST_TIMERS.DISABLED}}Toast.maxToastCount=4,Toast.currentToastCount=0,Toast.timersEnabled=TOAST_TIMERS.ELAPSED,Toast.queueEnabled=!0,Toast.queue=[];
//# sourceMappingURL=bootstrap-toaster.min.js.map