module.exports = function (grunt) {

    grunt.initConfig({
        pkg: grunt.file.readJSON('package.json'),
        connect: {
            server: {
                options: {
                    port: '8999',
                    hostname: '*',
                    base: 'examples',
                    livereload: 35678,
                    //open: true,
                },
            },
        },
        uglify: {
            publish: {
                files: {
                    'dist/jquery.qbslider.min.js': ['dist/jquery.qbslider.js'],
                    'examples/files/jquery.qbslider.min.js': ['dist/jquery.qbslider.js'],
                },
                options: {
                    banner: '/*! <%= pkg.title || pkg.name %> - v<%= pkg.version %>;' +
                            ' Copyright (c) <%= grunt.template.today("yyyy") %> <%= pkg.author %>;' +
                            ' Licensed <%= pkg.license %>; <%= pkg.homepage %> */\n',
                    mangle: {
                        screw_ie8: true
                    },
                    compress: {
                        screw_ie8: true,
                        drop_console: true
                    },
                }
            }
        },
        concat: {
            publish: {
                src: [
                    'src/license.js',
                    'src/define.js',
                    'src/helpers.js',
                    'src/slider.js',
                    'src/plugin.js'
                ],
                dest: 'dist/jquery.qbslider.js',
                options: {
                    footer: '}));'
                }
            }
        },
        watch: {
            plugin: {
                files: ['src/*'],
                tasks: ['concat:publish', 'uglify:publish']
            },
            sass: {
                files: ['examples/scss/**/*.scss'],
                tasks: ['sass:publish']
            },
            css: {
                files: ['examples/files/*.css'],
                tasks: [],
                options: {
                    livereload: 35678
                }
            }
        },
        sass: {
            publish: {
                options: {
                    style: 'compact',
                    sourcemap: 'none',
                },
                files: {
                    'examples/files/examples.css': 'examples/scss/examples.scss'
                }
            }
        }
    });

    grunt.loadNpmTasks('grunt-contrib-uglify');
    grunt.loadNpmTasks('grunt-contrib-concat');
    grunt.loadNpmTasks('grunt-contrib-watch');
    grunt.loadNpmTasks('grunt-contrib-sass');
    grunt.loadNpmTasks('grunt-contrib-connect');

    // Default task(s).
    grunt.registerTask('default', ['connect:server','watch']);

};