(function ($) {

    window.qbslider = null;

    var examples = {
        lists: $('.js-skin-list>div').append('<ul class="slide-list" />').children('.slide-list'),
        buttons: {
            create: $('.js-create'),
            destroy: $('.js-destroy'),
            next: $('.js-next'),
            prev: $('.js-prev'),
            set: $('.js-set'),
            add: $('.js-add'),
        },
        content: 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. ' +
                'Proin lorem felis, facilisis id dolor nec, posuere elementum velit. ' +
                'Integer eget accumsan libero. Aliquam cursus eros sit amet lacinia pharetra. ' +
                'In hac habitasse platea dictumst. Aliquam in orci dignissim felis volutpat ' +
                'posuere laoreet eget leo. Nulla malesuada orci id odio egestas, ac scelerisque ' +
                'erat vestibulum. Praesent auctor sit amet mi sodales vestibulum. ' +
                'Aliquam fringilla eleifend ipsum id ullamcorper. Etiam quis venenatis sem, ' +
                'ut commodo libero. Sed vitae ante ex. Nam vitae congue tortor. Sed mollis sem ' +
                'eros. Vivamus eu convallis erat. Vestibulum facilisis vel neque egestas congue. ' +
                'In sit amet tortor ex. Morbi sed ultrices nulla. ',
        init: function () {
            for (var i = 1; i < 6; i++) {
                this.lists.append('<li class="slide"><h5 class="slide-title">Title for slide ' + i + '</h5><p class="slide-desc">' + this.content + '</p></li>');
            }
            this.buttons.create.one('click', this.createSliders.bind(this));
        },
        destroySliders: function () {
            window.qbslider = null;
            this.auto.slider = null;
            $('.slide-list').qbslider('destroy');
            clearInterval(this.auto.interval);
            this.buttons.destroy.addClass('is-disabled');
            this.buttons.create.one('click', this.createSliders.bind(this)).removeClass('is-disabled');
            this.buttons.next.off('click').addClass('is-disabled');
            this.buttons.prev.off('click').addClass('is-disabled');
            this.buttons.set.off('click').addClass('is-disabled');
            this.buttons.add.off('click').addClass('is-disabled');
        },
        createSliders: function () {
            window.qbslider = $('.skin-metalic>.slide-list').qbslider({
                next: this.buttons.next.text(),
                prev: this.buttons.prev.text()
            });

            $('.skin-flat>.slide-list').qbslider({
                start: 1,
                controls: false,
                mousewheel: false,
                speed: 0,
                navText: function (i, el) {
                    return $(el).find('.slide-title').text();
                }
            });

            $('.skin-compact>.slide-list').qbslider({
                start: 2,
                nav: false,
                next: '<div>&gt;</div>',
                prev: '<div>&lt;</div>'
            });

            this.auto.slider = $('.skin-auto>.slide-list').qbslider({
                start: 3,
                controls: false,
                navText: function (i, el) {
                    return '&#9679;';
                }
            });

            this.buttons.create.addClass('is-disabled');
            this.buttons.destroy.one('click', this.destroySliders.bind(this)).removeClass('is-disabled');
            this.buttons.next.on('click', this.nextSlide.bind(this)).removeClass('is-disabled');
            this.buttons.prev.on('click', this.prevSlide.bind(this)).removeClass('is-disabled');
            this.buttons.set.on('click', this.setSlide.bind(this)).removeClass('is-disabled');
            this.buttons.add.on('click', this.addSlide.bind(this)).removeClass('is-disabled');
            this.auto.interval = setInterval(this.auto.slide.bind(this.auto), 3000);
        },
        nextSlide: function () {
            $('.slide-list').qbslider('nextSlide');
        },
        prevSlide: function () {
            $('.slide-list').qbslider('prevSlide');
        },
        setSlide: function () {
            $('.slide-list').qbslider('setSlide', 3);
        },
        addSlide: function () {
            var slide = $('<li class="slide"><h5 class="slide-title">Title for added slide</h5><p class="slide-desc">' + this.content + '</p></li>');
            $('.slide-list').each(function () {
                $(this).qbslider('addSlide', slide.clone())
            });
        },
        auto: {
            interval: null,
            slider: null,
            next: true,
            slide: function () {
                var qbs = this.slider.data('qbslider');

                if (this.next) {

                    if ((qbs.index() + 1) < this.slider.children().length) {
                        qbs.nextSlide();
                    } else {
                        this.next = false;
                        qbs.prevSlide();
                    }
                    return;
                }

                if (qbs.index() > 0) {
                    qbs.prevSlide();
                } else {
                    this.next = true;
                    qbs.nextSlide();
                }
            }
        }
    };

    examples.init();
}(jQuery));