
    'use strict';

    var defaults = {
        /* Index of slide to show after initialization */
        start: 0,
        /* Animation speed */
        speed: 500,
        /* Number of slides that will be visible at once, current slide is always centered */
        slidesVisible: 1,
        /* Autoresizing of slides after window resizing */
        responsive: true,
        /* Generate navigation links */
        nav: true,
        /* Text of the navigation links - receives index and slide element */
        navText: function (i, el) {
            return (i + 1);
        },
        mousewheel: true,
        /* Generate next and previous slide buttons */
        controls: true,
        /* Text of the next slide button */
        next: '&#9679;',
        /* Text of the previous slide button */
        prev: '&#9679;'
    };

    /* helper function for finding index depending on argument passed */
    var _findIndexValue = function (arg) {

        /* just return a number */
        if (typeof arg === 'number') {
            return arg;
        }

        /* event passed with data attached */
        if (arg.data) {

            /*data as a single value */
            if (typeof arg.data === 'number') {
                return arg.data;
            }

            /* data as an object containing index value */
            if (arg.data.index) {
                return parseInt(arg.data.index, 10);
            }

        }

        /* if we couldn't find our index value, return false */
        return false;
    };

    /* Basic css that must be applied to the $el to make slider work */
    var _baseCss = {
        position: 'absolute',
        padding: 0,
        margin: 0,
        top: 0,
        left: 0,
        display: 'table'
    };

    /* private handler for mousewheel event - requires binding to the slider object */
    var _handleMouseWheel = function (ev) {

        ev.preventDefault();
        ev.cancelBubble = false;

        var change = (ev.type == 'mousewheel') ? ev.originalEvent.wheelDelta : ev.originalEvent.detail * -1;

        if (change > 0) {
            this.prevSlide();
        } else {
            this.nextSlide();
        }

        return false;
    };

    var transistionSupport = function () {
        var s = document.createElement('p').style;
        return 'transition' in s || 'WebkitTransition' in s || 'MozTransition' in s || 'msTransition' in s || 'OTransition' in s;
    };

    var cssChangeAnimate = function ($el, margin, speed) {
        $el.stop(true).animate({'margin-left': margin}, speed);
    };

    var cssChangeTransition = function ($el, margin) {
        $el.css('margin-left', margin);
    };

    var cssChange = transistionSupport() ? cssChangeTransition : cssChangeAnimate;