
/* Binding methods directly in the constructor allows easier access to those methods later, 
 * constrasting to defining methods in prototype, which is cool, but we don't really need it here. */
var QbSlider = function ($el, options) {

    /* Configuration merged with user defined options */
    var config = $.extend(true, {}, defaults, options);

    /* Object for all private elements. Contains active slide index
     * and all cached dom elements, they have to be nullified to get GC */
    var controls = {
        /* wrapper around the whole slider stuff */
        wrap: $('<div class="qbs-wrap" />'),
        /* container for the slider */
        slider: $('<div class="qbs-slider" />'),
        /* previous slider button */
        prev: $('<span class="qbs-button qbs-prev" />'),
        /* next slider button */
        next: $('<span class="qbs-button qbs-next" />'),
        /* navigation container */
        nav: $('<div class="qbs-nav" />'),
        /* just slides */
        slides: $el.children(),
        /* active slide */
        active: $el.children(':nth-child(' + config.start + ')'),
        /* Index of the active slide */
        index: config.start,
        /* the initial list */
        el: $el
    };

    /* Exposed access to the currently active slide element */
    this.active = function () {
        return controls.active;
    };

    /* Exposed index of the active slide */
    this.index = function () {
        return controls.index;
    }.bind(this);

    /* Exposed function to set next slide */
    this.nextSlide = function () {
        if ((controls.index + 1) < controls.slides.length) {
            this.setSlide(controls.index + 1);
        }
    }.bind(this);

    /* Exposed function to set previous slide */
    this.prevSlide = function () {
        if (controls.index > 0) {
            this.setSlide(controls.index - 1);
        }
    }.bind(this);

    /* Exposed function to set any slide */
    this.setSlide = function (index) {

        var newindex = _findIndexValue(index);

        if (typeof newindex !== 'number' || newindex < 0 || controls.slides.length < newindex) {
            return;
        }

        /* setting active slide */
        controls.active.removeClass('qbs-active');
        controls.active = controls.slides.eq(newindex).addClass('qbs-active');

        /* index for the new active slide */
        controls.index = newindex;

        /* if navigation is set, set active link */
        if (config.nav) {
            controls.nav.children().removeClass('qbs-link-active').eq(newindex).addClass('qbs-link-active');
        }

        /* animating the change - this function is generated based on the transistion support */
        cssChange(controls.el, (controls.slider.width() - controls.active.width()) / 2 - controls.active.position().left, config.speed);

        /* return false for easier event attachment for links */
        return false;

    }.bind(this);

    this.addSlide = function (slide) {

        var content = config.navText(controls.el.children().length, slide);

        if (config.nav) {
            controls.nav.append('<span class="qbs-link" data-index="' + controls.el.children().length + '">' + content + '</span>');
        }

        var size = controls.slider.width() / config.slidesVisible;

        slide.appendTo(controls.el).wrapInner('<div class="qbs-slide-content" />').css({width: size, display: 'table-cell'});

        controls.el.css('width', size * controls.el.children().length);
        controls.slides = controls.el.children();
    }.bind(this);

    /* Recalculate slider if needed */
    this.resizeSlides = function () {
        var size = controls.slider.width() / config.slidesVisible;
        controls.el.children().css('width', size);
        controls.el.css('width', size * controls.el.children().length);
        controls.slider.css('height', controls.el.height());
        this.setSlide(controls.index);
    }.bind(this);

    /* Exposed cleanup function */
    this.destroy = function () {

        var i;

        /* stop animation */
        controls.el.stop(true);

        /* unbind events */
        if (config.controls) {
            controls.prev.off('click');
            controls.next.off('click');
        }
        if (config.nav) {
            controls.nav.off('click', '.qbs-link');
        }
        if (config.responsive) {
            $(window).off('resize', this.resizeSlides);
        }

        /* remove created structure */
        controls.wrap.before(controls.el).remove();

        /* cleanup slides */
        controls.slides.removeAttr('style');
        $('.qbs-slide-content').children().unwrap();
        controls.active.removeClass('qbs-active');

        /* cleanup slide list */
        controls.el.removeData('qbslider').removeAttr('style');
        controls.el = null;

        /* cleanup all references to the removed elements and all properties of this object */
        for (i in controls) {
            controls[i] = null;
        }

        for (i in this) {
            this[i] = null;
        }

        controls = null;
        config = null;


    }.bind(this);

    /* Initialize the slider */
    var init = function () {

        /* Build slider */
        controls.el.after(controls.wrap);
        controls.slider.append(controls.el).appendTo(controls.wrap);
        controls.slides.wrapInner('<div class="qbs-slide-content" />');

        /* Add controls */
        if (config.controls) {
            controls.prev.html(config.prev).appendTo(controls.wrap).on('click', this.prevSlide);
            controls.next.html(config.next).appendTo(controls.wrap).on('click', this.nextSlide);
        }

        /* Add navigation */
        if (config.nav) {
            controls.nav.appendTo(controls.wrap);
            controls.slides.each(function (i, $el) {
                controls.nav.append('<span class="qbs-link" data-index="' + i + '">' + config.navText(i, $el) + '</span>');
            });
            controls.nav.on('click.qbs', '.qbs-link', function () {
                controls.el.data('qbslider').setSlide(parseInt($(this).attr('data-index'), 10));
            });
        }

        /* binding mousewheel events */
        if (config.mousewheel) {
            controls.wrap.on('mousewheel.qbs DOMMouseScroll.qbs', _handleMouseWheel.bind(this));
        }

        /* Setting the most important styles, without them slider will not work */
        /* Slide list container */
        controls.slider.css({
            overflow: 'hidden',
            position: 'relative'
        });

        /* If animation is transition, add add required styling */
        if (transistionSupport()) {
            controls.el.css('transition', 'margin-left ' + config.speed + 'ms ' + controls.el.css('transition'));
        }

        /* Add more required css and assign slider object to controls.el. */
        controls.el.css(_baseCss).data('qbslider', this).children().css('display', 'table-cell');

        this.resizeSlides();

        if (config.responsive) {
            $(window).on('resize', this.resizeSlides);
        }
    }.bind(this);

    init();
};

 