# Bootstrap Off-Canvas Nav

<img align="right" src="https://raw.githubusercontent.com/marcandrews/bootstrap-off-canvas-nav/master/doc/preview.gif">Super simple, super easy off-canvas nav for Bootstrap, requiring no additional markup to default Bootstrap navbar semantics.

## Features
* compatible with fixed and static navbars
* compatible with dropdowns
* slide animation
* animated ```navbar-toggle``` button
* closes when escape key is pressed

## Installation

Add ```bootstrap-off-canvas-nav.css``` from the [src](https://github.com/marcandrews/bootstrap-off-canvas-nav/tree/master/src) folder to your HTML document after your ```bootstrap.css```:

```html
<link rel="stylesheet" href="bootstrap-off-canvas-nav.css"/>
```

Add ```bootstrap-off-canvas-nav.js``` from the [src](https://github.com/marcandrews/bootstrap-off-canvas-nav/tree/master/src) folder to your HTML document after your ```jquery.js``` and ```bootstrap.js```:

```html
<script src="bootstrap-off-canvas-nav.js"></script>
```

*That's it!*

## Options

For a left-side off-canvas nav, add ```off-canvas-nav-left``` class to your ```<body>``` tag:

```html
<body class="off-canvas-nav-left">
```

## Examples

* [static top nav](http://htmlpreview.github.io/?https://github.com/marcandrews/bootstrap-off-canvas-nav/blob/master/test/navbar-static-top.htm)
* [static top left-side nav](http://htmlpreview.github.io/?https://github.com/marcandrews/bootstrap-off-canvas-nav/blob/master/test/navbar-static-top-left.htm)
* [fixed top nav](http://htmlpreview.github.io/?https://github.com/marcandrews/bootstrap-off-canvas-nav/blob/master/test/navbar-fixed-top.htm)
* [fixed top left-side nav](http://htmlpreview.github.io/?https://github.com/marcandrews/bootstrap-off-canvas-nav/blob/master/test/navbar-fixed-top-left.htm)

See the [test](https://github.com/marcandrews/bootstrap-off-canvas-nav/tree/master/test) folder for more information.
