jQuery Selfheal animation plugin
========

jQuery animation plugin inspired by the selfheal design pattern from Yahoo's Design Pattern Library.

Use plugin to ease the transition when adding or removing elements from the DOM.

To remove or show an element call .selfheal() on it. If the element is visible, it will be faded out, 
and then have its height animated to zero. If it is not visible its opacity will be set to 0 and 
its height animated to normal. It will then be faded to opaque. You can supply options for duration and calback.

Note that this plugin does not remove the element from the DOM. If that is needed, do it
within a callback function. You can also supply a duration like ordinary jQuery animation, but note that
the actual time the animation will take will be twice that, as the duration is used both for fading out/in
and sliding up/down. 

Read more about the design pattern here: http://developer.yahoo.com/ypatterns/richinteraction/transition/selfhealing.html

Works in IE7+, Opera, Firefox and Chrome (latest). It is reasonable to believe it will work in older versions of modern browser as well as the animation is based on tried and tested fadeTo and slideUp/Down.
There is a rendering bug in IE7 where list bullets will be offset downwards, perhaps because of the element not actually be removed. 

Usage example:

$("#element").selfheal();

$("#element").selfheal({duration:600, callback: function(){ alert("Done!"); }});

