# jquery-paste [![GitHub license](https://img.shields.io/badge/license-MIT-blue.svg)](LICENSE)

jQuery Paste Plugin.

**Cross-browser** handler of paste event for text and images.

## Usage

```js
$('textarea').pastableTextarea();
// or
$.pastableTextarea($('textarea'));
```

## Events

### `pasteText`

```js
.on('pasteText', function(event, text) {
    console.info(text);
})
```

### `pasteImage`

```js
.on('pasteImage', function(event, image) {
    console.info(image.blob);
    console.info(image.height);
    console.info(image.width);
    
    $('img').attr('src', image.dataURL);
})
```

### `pasteError`

```js
.on('pasteError', function(event, err) {
    console.info(err.message);
})
```

## LICENSE

[**MIT**](LICENSE)
