/**
 * Vertical Align version 1.0
 * https://github.com/erensuleymanoglu/vertical-align
 * by Eren Süleymanoğlu
 */
(function ($) {
	
	'use strict';
	
	$.fn.verticalAlign = function () {
		
		return this.each(function () {
			var a = $(this);
			
			var center = function () {
				
				var b = a.parent();
				var c = a.outerHeight();
				var d = b.outerHeight();
				var e = 0;
				
				b.children().each(function () {
					if ($(this).is(a)) {
						return false;
					}
					
					e += $(this).outerHeight(true);
				});
				
				var f = d - e;
				var g = (f / 2) - (c / 2);
				
				a.css({
					'margin-top' : g
				})
			};
			
			$(window).on('load', function () {
				center();
			});
			
			$(window).on('resize', function () {
				center();
			});
			
		});
		
	};
	
})(jQuery);