(function($)
{
  $.fn.jAnim=function(options){

    var defauts={
      "interval": 150,
      "speed": 300,
      "animFunction": 'ease',
      "animation": "fading",
      "action": true, // True = fading , False = Disfading
      "callback": null
    };

    var options = $.extend(defauts, options);
     
    return this.each(function(){

      var element=$(this);

      switch(options.animation) {
          case 'appear':
                $(element.children()).css(     
                {
                     'opacity' : '0'
                });
              break;
          case 'flip':
                $(element.children()).css(     
                {
                  'opacity' : '0',
                  '-moz-transform' : 'translateY(-100px) rotateX(180deg)' ,
                  '-webkit-transform' : 'translateY(-100px) rotateX(180deg)' ,
                  '-o-transform' : 'translateY(-100px) rotateX(180deg)' ,
                  '-ms-transform' : 'translateY(-100px) rotateX(180deg)' ,
                  'transform' : 'translateY(-100px) rotateX(180deg)' 
                });
              break;
          default:
      }

      // Ading smooth effect
      $(element.children()).css(     
      {
      '-webkit-transition' : 'all ' + options.speed +  'ms ' + options.animFunction ,
         '-moz-transition' : 'all ' + options.speed +  'ms ' + options.animFunction ,
          '-ms-transition' : 'all ' + options.speed +  'ms ' + options.animFunction ,
           '-o-transition' : 'all ' + options.speed +  'ms ' + options.animFunction ,
              'transition' : 'all ' + options.speed +  'ms ' + options.animFunction 
      });

      // Laisse le temps au selecteur de recevoir le CSS de pré-animation
      setTimeout(function(){

        //
        if (options.action) {
          $(element.children()).each(function(i) {
            var $me = $(this);
            setTimeout(function(){
              $me.addClass('jAnim-' + options.animation + "-show");
            }, i*options.interval);
          });  
        }
        else {
          $(element).each(function(i) {
            var $me = $(this);
            setTimeout(function(){
              $me.removeClass('jAnim-' + options.animation + "-show");
            }, i*options.interval);
          });  
        }

      }, options.speed);

         
      if(options.callback){ options.callback(); }
    });
  };
})(jQuery);


