# Embedstagram

A Lightweight jQuery plugin to create a responsive, customisable Instagram feed. Pull photos from a user or hashtag. Visit the [Demo](http://embedstagram.neioo.com) to see it in action.

## Basic Usage

Include [jQuery](http://jquery.com), `jquery.embedstagram.js` and `embedstagram.css` in your page. See `example.html` for suggestions on placement.

You must **always** declare a `client_id` along with **either** a `username` or `hashtag`.

```html
<div id="embedstagram"></div>
```

```javascript
$('#embedstagram').embedstagram({
  client_id: 'your-client-id-here',
  username: 'your-username-here'
});
```

### Generating a Client ID

1. Go to the [Instagram Developer Page](https://instagram.com/developer) and click 'Register Your Application'.
2. Fill out the name, description and set both the website URL and Redirect URI to the address of your website.
3. Copy the newly generated 'Client ID' and implement as described above.

## Parameters

You can pass in extra parameters to control certain aspects of Embedstagram like so:

```javascript
$('#embedstagram').embedstagram({
  param1: value,
  param2: value,
  param3: value //no trailing comma
});
```

### Required

- **Client ID** (string): See above for how to generate a Client ID.

  `client_id: 'your-client-id-here'`

- **Username** (string)

  `username: 'your-username-here'`

- **Hashtag** (string)

  `hashtag: 'your-hashtag-here'`

### Defaults

- **Count** (number): Number of photos called at a time (maximum 33).

  `count: 12`

- **Responsive** (boolean): Whether the photos will resize automatically.

  `responsive: true`

- **Load More** (boolean): Whether the load more button is visible.

  `load_more: true`

- **Thumbnail Style** (string): Shape or style of the photos. See below.

  `thumb: 'default'`

- **Theme** (string): Colour and style of borders, buttons and elements. See below.

  `theme: 'default'`

## Styling

See the [demo](http://embedstagram.neioo.com) to preview styles. Implement them like so:

```javascript
$('#embedstagram').embedstagram({
  client_id: 'your-client-id-here',
  username: 'your-username-here',
  thumb: 'tile',
  theme: 'dark'
});
```

Thumbnail:

- default
- border
- tile
- circle

Theme:

- default
- light
- dark

## Errors

- `You cannot view this resource`

  Your Instagram profile may be private. It must be public to use this plugin.

- `This tag cannot be viewed`
  
  You are using a hashtag which Instagram has [banned](http://thedatapack.com/banned-hashtags-instagram).