export function fontInfo(element, explicitLineHeight) {
    var computedStyle = window.getComputedStyle(element);
    var fontFamily = computedStyle.fontFamily;
    var lineHeight = computedStyle.lineHeight;
    var lineHeightRatio = null;
    var maxLineHeight = null;
    if (lineHeight && lineHeight !== 'normal') {
        var matchs = lineHeight.match(/^(\d+(?:\.?\d+)?)(\w*)$/);
        lineHeightRatio = parseFloat(matchs[1]);
        switch (matchs[2]) {
            case '%':
                lineHeightRatio /= 100;
                break;
            case 'px':
                if (explicitLineHeight) {
                    maxLineHeight = lineHeightRatio;
                }
                lineHeightRatio /= parseFloat((computedStyle.fontSize || element.style.fontSize));
                break;
        }
    }
    else {
        lineHeightRatio = -1;
    }
    return {
        fontFamily: fontFamily,
        lineHeightRatio: lineHeightRatio,
        maxLineHeight: maxLineHeight
    };
}
//# sourceMappingURL=fontInfo.js.map