import { lru_cached } from '../lru';
var invisibleElement = document.createElement('div');
invisibleElement.style.position = 'absolute';
invisibleElement.style.top = '0px';
invisibleElement.style.left = '0px';
invisibleElement.style.visibility = 'hidden';
invisibleElement.style.height = 'auto';
invisibleElement.style.width = 'auto';
invisibleElement.style.zIndex = "-9999";
invisibleElement.innerText = "h";
document.addEventListener('DOMContentLoaded', init);
var initialized = false;
function init() {
    if (!initialized) {
        initialized = true;
        document.body.appendChild(invisibleElement);
    }
}
var cachedGetLineHeightRatio = lru_cached(3000)(function (fontFamily, fontSize) {
    init();
    invisibleElement.style.fontFamily = fontFamily;
    invisibleElement.style.fontSize = fontSize + "px";
    return invisibleElement.clientHeight / fontSize;
});
export function getLineHeightRatio(fontFamily, fontSize) {
    return cachedGetLineHeightRatio(fontFamily, fontSize);
}
//# sourceMappingURL=lineHeight.js.map