import { getLineHeightRatio } from './lineHeight';
var canvas = document.createElement('canvas');
var ctx = canvas.getContext('2d');
ctx.font = "10px Arial,sans-serif";
export function computeWidthHeightRatio(fontFamily, text) {
    ctx.font = "10px " + fontFamily;
    return ctx.measureText(text).width / 10;
}
export function estimateLinesCount(wordRatios, args) {
    var fontSize = args.fontSize, maxWidth = args.maxWidth;
    var currentLineWidth = 0;
    var lines = 1;
    for (var _i = 0, wordRatios_1 = wordRatios; _i < wordRatios_1.length; _i++) {
        var r = wordRatios_1[_i];
        var wordSize = r * fontSize;
        if (wordSize >= maxWidth - 5) {
            return -1;
        }
        if (currentLineWidth + wordSize >= maxWidth - 5) {
            lines++;
            currentLineWidth = 0;
        }
        currentLineWidth += wordSize;
    }
    return lines;
}
export function estimateHeight(wordRatios, args) {
    var fontFamily = args.fontFamily, fontSize = args.fontSize, lineHeightRatio = args.lineHeightRatio;
    var linesCount = estimateLinesCount(wordRatios, args);
    if (lineHeightRatio < 0) {
        lineHeightRatio = getLineHeightRatio(fontFamily, fontSize);
    }
    var computedHeight = fontSize * linesCount * lineHeightRatio;
    return computedHeight;
}
//# sourceMappingURL=widthsHeights.js.map