var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
import { fontInfo, computeWidthHeightRatio, estimateHeight } from './helpers/index';
export function fillParentContainer(element, opts) {
    if (opts === void 0) { opts = {}; }
    // 1. Parse options
    var _a = opts.minFontSize, minFontSize = _a === void 0 ? 4 : _a, _b = opts.maxFontSize, maxFontSize = _b === void 0 ? 40 : _b, _c = opts.explicitLineHeight, explicitLineHeight = _c === void 0 ? false : _c, _d = opts.maxWidth, maxWidth = _d === void 0 ? null : _d, _e = opts.maxHeight, maxHeight = _e === void 0 ? null : _e, _f = opts.multiline, multiline = _f === void 0 ? true : _f;
    var _g = fontInfo(element, explicitLineHeight), fontFamily = _g.fontFamily, lineHeightRatio = _g.lineHeightRatio, maxLineHeight = _g.maxLineHeight;
    // 2. Apply defaulting rules
    maxHeight = maxHeight || element.parentElement.clientHeight;
    maxWidth = maxWidth || element.parentElement.clientWidth;
    var algoParams = {
        fontFamily: fontFamily,
        fontSize: 0,
        lineHeightRatio: lineHeightRatio,
        minFontSize: minFontSize,
        maxHeight: maxHeight,
        maxWidth: maxWidth,
        maxFontSize: maxFontSize && Number(maxFontSize) > 0 ? maxFontSize : maxHeight,
        maxLineHeight: maxLineHeight && Number(maxLineHeight) > 0 ? maxLineHeight : maxHeight,
    };
    // 3. tokenize text
    var text = element.textContent || '';
    var tokenizedText = multiline ? text.split(/(:? )/) : [text];
    var widthHeightRatios = tokenizedText.map(function (text) { return computeWidthHeightRatio(fontFamily, text); });
    // 4. compute the optimal font-size!
    var optimalSize = optimalFontSize(widthHeightRatios, algoParams);
    element.style.fontSize = optimalSize + "px";
}
function optimalFontSize(wordRatios, args) {
    var minFontSize = args.minFontSize, maxHeight = args.maxHeight, maxFontSize = args.maxFontSize, maxLineHeight = args.maxLineHeight, maxWidth = args.maxWidth;
    var low = Math.floor(minFontSize);
    var high = Math.floor(Math.min.apply(Math, [maxHeight, maxFontSize, maxLineHeight].concat(wordRatios.map(function (r) { return maxWidth / r; }))));
    if (low >= high || checkConstraints(wordRatios, __assign({}, args, { fontSize: high }))) {
        return Math.max(low, high);
    }
    while (low < high && high - low > 1) {
        var fontSize = (low + high) >>> 1;
        if (checkConstraints(wordRatios, __assign({}, args, { fontSize: fontSize }))) {
            low = fontSize;
        }
        else {
            high = fontSize;
        }
    }
    return low;
}
function checkConstraints(wordRatios, args) {
    var maxHeight = args.maxHeight;
    var height = estimateHeight(wordRatios, args);
    return height > 0 && height <= maxHeight;
}
//# sourceMappingURL=index.js.map