/**
 * @todo put this in a separate package
 */
export declare type NullableCacheEntry<TKey, TValue> = CacheEntry<TKey, TValue> | null;
export declare class CacheEntry<TKey, TValue> {
    key: TKey;
    value: TValue;
    older: NullableCacheEntry<TKey, TValue>;
    newer: NullableCacheEntry<TKey, TValue>;
    constructor(key: TKey, value: TValue);
}
export declare class LRUCache<TKey extends string | number, TValue> {
    limit: number;
    size: number;
    oldest: NullableCacheEntry<TKey, TValue>;
    newest: NullableCacheEntry<TKey, TValue>;
    private keymap;
    constructor(limit?: number);
    clear(): void;
    getItem(key: TKey): TValue | undefined;
    setItem(key: TKey, value: TValue): void;
}
export declare function lru_cached(limit: number): (target: any) => (...args: any[]) => any;
