var CacheEntry = /** @class */ (function () {
    function CacheEntry(key, value) {
        this.key = key;
        this.value = value;
        this.older = null;
        this.newer = null;
    }
    return CacheEntry;
}());
export { CacheEntry };
var LRUCache = /** @class */ (function () {
    function LRUCache(limit) {
        if (limit === void 0) { limit = 0; }
        this.limit = limit;
        /* double linked list */
        this.size = 0;
        this.oldest = null;
        this.newest = null;
        this.keymap = new Map();
    }
    LRUCache.prototype.clear = function () {
        this.oldest = this.newest = null;
        this.size = 0;
        this.keymap.clear();
    };
    LRUCache.prototype.getItem = function (key) {
        if (!this.keymap.has(key)) {
            return undefined;
        }
        var entry = this.keymap.get(key);
        if (this.newest !== entry) {
            var older = entry.older;
            var newer = entry.newer;
            entry.newer = null;
            entry.older = this.newest;
            this.newest.newer = entry;
            this.newest = entry;
            newer.older = older;
            if (older) {
                older.newer = newer;
            }
            if (entry === this.oldest) {
                this.oldest = newer;
            }
        }
        return entry.value;
    };
    LRUCache.prototype.setItem = function (key, value) {
        if (this.getItem(key)) {
            var entry = this.keymap.get(key);
            entry.value = value;
        }
        else {
            var entry = new CacheEntry(key, value);
            if (!this.limit || this.size < this.limit) {
                this.size++;
            }
            else {
                var firstEntry = this.oldest;
                this.oldest = firstEntry.newer;
                this.oldest.older = null;
                this.keymap.delete(firstEntry.key);
            }
            entry.older = this.newest;
            if (this.newest) {
                this.newest.newer = entry;
            }
            this.newest = entry;
            if (!this.oldest) {
                this.oldest = entry;
            }
            this.keymap.set(key, entry);
        }
    };
    return LRUCache;
}());
export { LRUCache };
export function lru_cached(limit) {
    var cache = new LRUCache(limit);
    return function (target) {
        return function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var key = args.map(function (v) { return "" + v; }).join(';');
            var value = cache.getItem(key);
            if (!value) {
                value = target.apply(this, args);
                cache.setItem(key, value);
            }
            return value;
        };
    };
}
//# sourceMappingURL=index.js.map