/*!
 * VNS.Gallery - jQuery Plugin
 * @version 1.0.3
 * @author Martin H. Schläger
 * @license MIT
 * @repository https://github.com/schlagerdk/VNS.Gallery
 *
 * Copyright (c) 2025-present Vital New Software ApS
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
!function(t){"use strict";var i={useCarousel:!0,loop:!1,step:null,showAllButton:!0,maxImages:null,showMoreIndicator:!0,moreIndicatorAction:"modal",moreIndicatorText:"...",showNavigation:!0,showCounter:!0,showCloseButtonGrid:!0,showCloseButtonSingle:!0,enableKeyboard:!0,enableDrag:!0,dragThreshold:50,hoverEffect:!1,captions:!1,captionSelector:"img",captionType:"attr",captionsData:"alt",captionPosition:"outside-center",captionDelay:0,showAllText:"Show all",prevText:"◀",nextText:"▶",thumbPrevText:"‹",thumbNextText:"›",columns:null,modalColumns:4,modalWidth:"80vw",responsive:null,onShow:function(){},onShown:function(){},onChange:function(){},onChanged:function(){},onClose:function(){},onClosed:function(){},onNext:function(){},onNextDone:function(){},onPrev:function(){},onPrevDone:function(){},onError:function(){}};function s(s,n){this.element=s,this.$element=t(s),this.options=t.extend(!0,{},i,n),this.instanceId="vnsGallery_"+Math.random().toString(36).substr(2,9),this.images=[],this.currentIndex=0,this.thumbPosition=0,this.itemsPerPage=0,this.maxPosition=0,this.modal=null,this.resizeTimeout=null,this.dragState={isDragging:!1,isModalDrag:!1,startX:0,startY:0,currentX:0,currentTranslate:0,prevTranslate:0,animationID:null},this.init()}s.prototype={init:function(){this.collectImages(),this.applyResponsiveSettings(),this.buildHTML(),this.options.useCarousel&&this.initCarousel(),this.bindEvents(),this.$element.trigger("init")},collectImages:function(){var i=this;this.images=[],this.$element.find("img").each(function(){var s=t(this),n=s.parent(),e="";if(i.options.captions){var a="self"===i.options.captionSelector?n:s;e="data"===i.options.captionType?a.data(i.options.captionsData)||"":"text"===i.options.captionType?a.text()||"":a.attr(i.options.captionsData)||""}i.images.push({src:s.attr("src"),fullsize:s.attr("data-fullsize")||s.attr("src"),alt:s.attr("alt")||"",title:s.attr("title")||"",caption:e})})},buildHTML:function(){if(this.$element.empty(),this.$element.addClass("vns-gallery-container"),this.options.hoverEffect&&this.$element.addClass("vns-gallery-hover-enabled"),this.options.useCarousel){var i='<div class="vns-gallery-thumbnail-carousel-container mt-4"'+((s=this.currentResponsiveColumns||this.options.columns||null)?' data-columns="'+s+'"':"")+">";i+='<div class="vns-gallery-thumbnail-header">',i+='<div class="vns-gallery-thumbnail-nav-controls">',this.options.showAllButton&&(i+='<button class="vns-gallery-see-all-btn">'+this.options.showAllText+"</button>"),i+='<button class="vns-gallery-carousel-nav vns-gallery-thumb-prev">'+this.options.thumbPrevText+"</button>",i+='<button class="vns-gallery-carousel-nav vns-gallery-thumb-next">'+this.options.thumbNextText+"</button>",i+="</div></div>",i+='<div class="vns-gallery-thumbnail-carousel-wrapper">',i+='<div class="vns-gallery-thumbnail-carousel">',t.each(this.images,function(t,s){i+='<div class="vns-gallery-thumbnail-item">',i+='<img src="'+s.src+'" class="vns-gallery-thumbnail-img" alt="'+s.alt+'" data-index="'+t+'">',i+="</div>"}),i+="</div></div></div>",this.$element.append(i)}else{var s,n='<div class="vns-gallery-static-grid" data-columns="'+(s=this.options.columns||4)+'">',e=this.options.maxImages,a=this.images.length,o=e&&e<a?e:a,l=e&&a>e;t.each(this.images,function(t,i){t<o&&(n+='<div class="vns-gallery-static-item">',n+='<img src="'+i.src+'" class="vns-gallery-thumbnail-img" alt="'+i.alt+'" data-index="'+t+'">',n+="</div>")}),l&&this.options.showMoreIndicator&&(n+='<div class="vns-gallery-static-item vns-gallery-more-indicator">',n+='<div class="vns-gallery-more-indicator-content">'+this.options.moreIndicatorText+"</div>",n+="</div>"),n+="</div>",this.$element.append(n)}var r="vnsGalleryModal-"+this.generateId(),h='<div id="'+r+'" class="vns-gallery-modal" tabindex="-1" role="dialog">';(h+='<div class="vns-gallery-modal-dialog">',h+='<div class="vns-gallery-modal-content">',this.options.showCloseButtonGrid&&(h+='<button class="vns-gallery-modal-close vns-gallery-close-grid" aria-label="Close">&times;</button>'),this.options.showCloseButtonSingle&&(h+='<button class="vns-gallery-modal-close vns-gallery-close-single" style="display: none;" aria-label="Close">&times;</button>'),h+='<div class="vns-gallery-modal-body">',h+='<div class="vns-gallery-grid"></div>',h+='<div class="vns-gallery-single-container" style="display: none; width: '+this.options.modalWidth+';">',h+='<div class="vns-gallery-single">',h+='<div class="vns-gallery-lightbox-header">',this.options.showCounter&&(h+='<div class="vns-gallery-lightbox-counter">1 / '+this.images.length+"</div>"),h+='<div class="vns-gallery-lightbox-controls">',this.options.showAllButton&&(h+='<button class="vns-gallery-show-all-btn">'+this.options.showAllText+"</button>"),this.options.showNavigation&&(h+='<button class="vns-gallery-prev-btn">'+this.options.prevText+"</button>",h+='<button class="vns-gallery-next-btn">'+this.options.nextText+"</button>"),h+="</div></div>",h+='<div class="vns-gallery-image-wrapper">',h+='<div class="vns-gallery-loading">',h+='<div class="vns-gallery-spinner"></div>',h+="</div>",h+='<img class="vns-gallery-single-img" src="" alt="" style="max-height: 75vh; border-radius: 8px;">',this.options.captions&&this.options.captionPosition.startsWith("top"))&&(h+='<div class="vns-gallery-caption '+("vns-gallery-caption-"+this.options.captionPosition)+'" style="display: none;"></div>');this.options.captions&&this.options.captionPosition.startsWith("bottom")&&(h+='<div class="vns-gallery-caption '+("vns-gallery-caption-"+this.options.captionPosition)+'" style="display: none;"></div>');(h+="</div>",this.options.captions&&this.options.captionPosition.startsWith("outside"))&&(h+='<div class="vns-gallery-caption '+("vns-gallery-caption-"+this.options.captionPosition)+'" style="display: none;"></div>');h+="</div></div>",h+="</div></div></div>",this.$element.append(h),this.$modal=t("#"+r),this.modalId=r;var d=this.$modal.find(".vns-gallery-grid"),g=this.options.modalColumns;d.attr("data-columns",g),this.options.modalWidth&&d.css("max-width",this.options.modalWidth),t.each(this.images,function(t,i){d.append('<div class="col-auto"><img src="'+i.src+'" class="vns-gallery-grid-img" alt="'+i.alt+'" data-index="'+t+'"></div>')})},initCarousel:function(){this.itemsPerPage=this.getItemsPerPage(),this.totalItems=this.images.length,this.maxPosition=Math.max(0,this.totalItems-this.itemsPerPage),this.updateCarousel(),this.updateButtonVisibility()},getItemsPerPage:function(){if(void 0!==this.currentResponsiveColumns)return this.currentResponsiveColumns;if(null!==this.options.columns)return this.options.columns;var i=t(window).width();return i>=1024?4:i>=768?3:2},applyResponsiveSettings:function(){if(this.options.responsive){var i=t(window).width(),s=[];for(var n in this.options.responsive)this.options.responsive.hasOwnProperty(n)&&s.push(parseInt(n));s.sort(function(t,i){return t-i});for(var e=0,a=0;a<s.length;a++)i>=s[a]&&(e=s[a]);var o=this.options.responsive[e];o&&void 0!==o.columns&&(this.currentResponsiveColumns=o.columns)}},getStepSize:function(){return null!==this.options.step?this.options.step:this.itemsPerPage},updateCarousel:function(){var t=-this.thumbPosition*(100/this.itemsPerPage);this.$element.find(".vns-gallery-thumbnail-carousel").css("transform","translateX("+t+"%)")},updateButtonVisibility:function(){var t=this.$element.find(".vns-gallery-thumb-prev"),i=this.$element.find(".vns-gallery-thumb-next"),s=this.$element.find(".vns-gallery-see-all-btn"),n=this.$modal.find(".vns-gallery-show-all-btn");if(this.totalItems<=this.itemsPerPage)t.hide(),i.hide(),this.options.showAllButton&&(s.hide(),n.hide());else if(t.show(),i.show(),this.options.showAllButton&&(s.show(),n.show()),this.options.loop)t.prop("disabled",!1),i.prop("disabled",!1);else{var e=this.thumbPosition<=0,a=this.thumbPosition>=this.maxPosition;t.prop("disabled",e),i.prop("disabled",a)}},bindEvents:function(){var i=this,s="."+this.instanceId;this.$element.off(s),this.$element.on("click"+s,".vns-gallery-thumb-prev",function(t){t.preventDefault(),t.stopPropagation(),i.thumbPrev()}),this.$element.on("click"+s,".vns-gallery-thumb-next",function(t){t.preventDefault(),t.stopPropagation(),i.thumbNext()}),this.$element.on("click",".vns-gallery-see-all-btn",function(){i.openGrid()}),this.$element.on("click",".vns-gallery-thumbnail-img",function(){var s=t(this).data("index");i.openSingle(s)}),this.$element.on("click",".vns-gallery-more-indicator",function(){"modal"===i.options.moreIndicatorAction?i.openGrid():"load"===i.options.moreIndicatorAction&&i.loadMoreImages()}),this.$modal.on("click",".vns-gallery-grid-img",function(){var s=t(this).data("index");i.currentIndex=s,i.showSingleImage()}),this.$modal.on("click",".vns-gallery-prev-btn",function(){i.prev()}),this.$modal.on("click",".vns-gallery-next-btn",function(){i.next()}),this.$modal.on("click",".vns-gallery-show-all-btn",function(){i.showGrid()}),t(window).on("resize.vnsGallery-"+this.modalId,function(){clearTimeout(i.resizeTimeout),i.resizeTimeout=setTimeout(function(){i.handleResize()},100)}),this.options.enableKeyboard&&t(document).on("keydown.vnsGallery-"+this.modalId,function(t){i.$modal.hasClass("vns-gallery-open")&&("ArrowLeft"===t.key?(t.preventDefault(),i.prev()):"ArrowRight"===t.key?(t.preventDefault(),i.next()):"Escape"===t.key&&(t.preventDefault(),i.close()))}),this.$modal.find(".vns-gallery-modal-close").on("click",function(){i.close()}),this.$modal.on("click",function(s){t(s.target).hasClass("vns-gallery-modal")&&i.close()}),this.options.enableDrag&&this.options.useCarousel&&this.bindDragEvents(),this.options.enableDrag&&this.bindModalDragEvents()},thumbPrev:function(){var t=this.getStepSize();this.thumbPosition;this.thumbPosition-=t,this.thumbPosition<0&&(this.options.loop?this.thumbPosition=this.maxPosition:this.thumbPosition=Math.max(0,this.thumbPosition)),this.updateCarousel(),this.updateButtonVisibility()},thumbNext:function(){var t=this.getStepSize(),i=this.thumbPosition;this.thumbPosition+=t,this.thumbPosition>this.maxPosition&&(this.options.loop?i<this.maxPosition&&this.thumbPosition>this.maxPosition?this.thumbPosition=this.maxPosition:this.thumbPosition=0:this.thumbPosition=Math.min(this.maxPosition,this.thumbPosition)),this.updateCarousel(),this.updateButtonVisibility()},handleResize:function(){var t=this.currentResponsiveColumns;if(this.applyResponsiveSettings(),this.options.useCarousel&&t!==this.currentResponsiveColumns)return this.buildHTML(),void this.initCarousel();if(null===this.options.columns&&this.currentResponsiveColumns){var i=this.$element.find(".vns-gallery-thumbnail-carousel-container");i.length&&i.attr("data-columns",this.currentResponsiveColumns)}this.itemsPerPage=this.getItemsPerPage(),this.maxPosition=Math.max(0,this.totalItems-this.itemsPerPage),this.thumbPosition=Math.min(this.thumbPosition,this.maxPosition),this.updateCarousel(),this.updateButtonVisibility()},openGrid:function(){this.showGrid(),this.showModal()},openSingle:function(t){this.currentIndex=t,this.showModal(),this.showSingleImage()},showGrid:function(){this.$modal.find(".vns-gallery-single-container").hide(),this.$modal.find(".vns-gallery-grid").show(),this.$modal.find(".vns-gallery-close-grid").show(),this.$modal.find(".vns-gallery-close-single").hide()},showSingleImage:function(){var t=this;this.$modal.find(".vns-gallery-grid").hide(),this.$modal.find(".vns-gallery-single-container").show(),this.$modal.find(".vns-gallery-close-grid").hide(),this.$modal.find(".vns-gallery-close-single").show();var i=this.images[this.currentIndex],s=this.$modal.find(".vns-gallery-single-img"),n=this.$modal.find(".vns-gallery-loading");n.addClass("vns-gallery-active"),s.addClass("vns-gallery-loading-img");var e=new Image;e.onload=function(){n.removeClass("vns-gallery-active"),s.removeClass("vns-gallery-loading-img")},e.onerror=function(){n.removeClass("vns-gallery-active"),s.removeClass("vns-gallery-loading-img"),t.options.onError.call(t,t.currentIndex,i)},e.src=i.fullsize,s.attr("src",i.fullsize).attr("alt",i.alt),this.options.showCounter&&this.$modal.find(".vns-gallery-lightbox-counter").text(this.currentIndex+1+" / "+this.images.length),this.updateCaption(),this.updateModalNavigation(),this.options.onChanged.call(this,this.currentIndex,i),this.$element.trigger("changed",[this.currentIndex,i])},updateCaption:function(){var t=this.images[this.currentIndex],i=".vns-gallery-caption-"+this.options.captionPosition,s=this.$modal.find(i);this.options.captions&&t.caption?(s.text(t.caption),this.options.captionDelay>0?(s.hide(),setTimeout(function(){s.fadeIn(300)},this.options.captionDelay)):s.show()):s.hide()},updateModalNavigation:function(){if(!this.options.loop){var t=this.$modal.find(".vns-gallery-prev-btn"),i=this.$modal.find(".vns-gallery-next-btn");t.prop("disabled",0===this.currentIndex),i.prop("disabled",this.currentIndex===this.images.length-1)}},open:function(t){void 0!==t?this.openSingle(t):this.openGrid()},showModal:function(){var i=this;this.options.onShow.call(this),this.$element.trigger("show"),this.$modal.addClass("vns-gallery-open"),t("body").addClass("vns-gallery-no-scroll"),setTimeout(function(){i.options.onShown.call(i),i.$element.trigger("shown")},150)},hideModal:function(){var i=this;this.options.onClose.call(this),this.$element.trigger("close"),this.$modal.removeClass("vns-gallery-open"),t("body").removeClass("vns-gallery-no-scroll"),setTimeout(function(){i.options.onClosed.call(i),i.$element.trigger("closed")},150)},close:function(){this.hideModal()},next:function(){this.options.onNext.call(this,this.currentIndex),this.$element.trigger("next",[this.currentIndex]),this.options.loop?this.currentIndex=(this.currentIndex+1)%this.images.length:this.currentIndex=Math.min(this.currentIndex+1,this.images.length-1),this.options.onChange.call(this,this.currentIndex),this.$element.trigger("change",[this.currentIndex]),this.showSingleImage(),this.options.onNextDone.call(this,this.currentIndex),this.$element.trigger("nextDone",[this.currentIndex])},prev:function(){this.options.onPrev.call(this,this.currentIndex),this.$element.trigger("prev",[this.currentIndex]),this.options.loop?this.currentIndex=(this.currentIndex-1+this.images.length)%this.images.length:this.currentIndex=Math.max(this.currentIndex-1,0),this.options.onChange.call(this,this.currentIndex),this.$element.trigger("change",[this.currentIndex]),this.showSingleImage(),this.options.onPrevDone.call(this,this.currentIndex),this.$element.trigger("prevDone",[this.currentIndex])},bindDragEvents:function(){var i=this,s=this.$element.find(".vns-gallery-thumbnail-carousel-wrapper");s.length&&(s.find("img").on("dragstart",function(t){t.preventDefault()}),s.on("mousedown",function(t){i.dragStart(t)}),t(document).on("mousemove.vnsGalleryDrag-"+i.instanceId,function(t){i.dragState.isDragging&&i.dragMove(t)}),t(document).on("mouseup.vnsGalleryDrag-"+i.instanceId,function(t){i.dragEnd(t)}),s.on("touchstart",function(t){i.dragStart(t.originalEvent.touches[0])}),s.on("touchmove",function(t){i.dragState.isDragging&&i.dragMove(t.originalEvent.touches[0])}),s.on("touchend",function(t){i.dragEnd(t)}))},dragStart:function(t){this.$modal&&this.$modal.hasClass("vns-gallery-open")||(this.dragState.isDragging=!0,this.dragState.isModalDrag=!1,this.dragState.startX=t.pageX||t.clientX,this.dragState.startY=t.pageY||t.clientY,this.dragState.currentX=this.dragState.startX,this.$element.find(".vns-gallery-thumbnail-carousel-wrapper").addClass("vns-gallery-dragging"))},dragMove:function(t){this.dragState.isDragging&&!this.dragState.isModalDrag&&(this.dragState.currentX=t.pageX||t.clientX,t.preventDefault())},dragEnd:function(t){if(this.dragState.isDragging&&!this.dragState.isModalDrag){this.dragState.isDragging=!1,this.$element.find(".vns-gallery-thumbnail-carousel-wrapper").removeClass("vns-gallery-dragging");var i=this.dragState.currentX-this.dragState.startX,s=Math.abs((t.pageY||t.clientY||this.dragState.startY)-this.dragState.startY);Math.abs(i)>this.options.dragThreshold&&Math.abs(i)>s&&(i>0?this.thumbPrev():this.thumbNext()),this.dragState.currentX=0}},bindModalDragEvents:function(){var i=this,s=this.$modal.find(".vns-gallery-single-container");s.length&&(s.find("img").on("dragstart",function(t){t.preventDefault()}),s.on("mousedown",".vns-gallery-single-img",function(t){i.modalDragStart(t)}),t(document).on("mousemove.vnsGalleryModalDrag-"+i.instanceId,function(t){i.dragState.isDragging&&i.dragState.isModalDrag&&i.modalDragMove(t)}),t(document).on("mouseup.vnsGalleryModalDrag-"+i.instanceId,function(t){i.dragState.isModalDrag&&i.modalDragEnd(t)}),s.on("touchstart",".vns-gallery-single-img",function(t){i.modalDragStart(t.originalEvent.touches[0])}),s.on("touchmove",function(t){i.dragState.isDragging&&i.dragState.isModalDrag&&i.modalDragMove(t.originalEvent.touches[0])}),s.on("touchend",function(t){i.dragState.isModalDrag&&i.modalDragEnd(t)}))},modalDragStart:function(t){this.dragState.isDragging=!0,this.dragState.isModalDrag=!0,this.dragState.startX=t.pageX||t.clientX,this.dragState.startY=t.pageY||t.clientY,this.dragState.currentX=this.dragState.startX,this.$modal.find(".vns-gallery-single-container").addClass("vns-gallery-dragging")},modalDragMove:function(t){this.dragState.isDragging&&this.dragState.isModalDrag&&(this.dragState.currentX=t.pageX||t.clientX,t.preventDefault())},modalDragEnd:function(t){if(this.dragState.isDragging&&this.dragState.isModalDrag){this.dragState.isDragging=!1,this.dragState.isModalDrag=!1,this.$modal.find(".vns-gallery-single-container").removeClass("vns-gallery-dragging");var i=this.dragState.currentX-this.dragState.startX,s=t.pageY||t.clientY?t.pageY||t.clientY:this.dragState.startY,n=Math.abs(s-this.dragState.startY);Math.abs(i)>this.options.dragThreshold&&Math.abs(i)>n&&(i>0?this.prev():this.next()),this.dragState.currentX=0}},loadMoreImages:function(){this.$element.find(".vns-gallery-more-indicator").remove();var i=this,s=this.$element.find(".vns-gallery-static-grid");t.each(this.images,function(t,n){if(t>=i.options.maxImages){var e='<div class="vns-gallery-static-item">';e+='<img src="'+n.src+'" class="vns-gallery-thumbnail-img" alt="'+n.alt+'" data-index="'+t+'">',e+="</div>",s.append(e)}}),this.options.maxImages=null},destroy:function(){this.$element.off(".vnsGallery"),this.$modal.off(".vnsGallery"),t(window).off("resize.vnsGallery-"+this.modalId),t(document).off("keydown.vnsGallery-"+this.modalId),t(document).off("mousemove.vnsGalleryDrag-"+this.instanceId),t(document).off("mouseup.vnsGalleryDrag-"+this.instanceId),t(document).off("mousemove.vnsGalleryModalDrag-"+this.instanceId),t(document).off("mouseup.vnsGalleryModalDrag-"+this.instanceId),this.$modal.remove(),this.$element.removeData("vnsGallery"),this.$element.trigger("destroyed")},refresh:function(){this.destroy(),this.init()},generateId:function(){return Math.random().toString(36).substr(2,9)}},t.fn.vnsGallery=function(i){var n,e=Array.prototype.slice.call(arguments,1);return this.each(function(){var a=t(this),o=a.data("vnsGallery");o||(o=new s(this,"object"==typeof i?i:{}),a.data("vnsGallery",o)),"string"==typeof i&&"function"==typeof o[i]&&o[i].apply(o,e),n=o}),n},t.fn.vnsGallery.defaults=i}(jQuery);