/*!
 * popup-multiselect v3.1.0 (https://github.com/harshniketseta/popupMultiSelect)
 * Copyright 2011-2019, Author: Harshniket Seta <harshniketseta@gmail.com>
 * Licensed under  ()
 */

!function(l){"use strict";function p(t,e){this.options=null,this.enabled=null,this.multiple=null,this.timeout=null,this.modalShown=null,this.$element=null,this.type="multiselect",this.init(t,e)}if(!l.fn.modal)throw new Error("MultiSelect requires modal.js");p.VERSION="3.1.0",p.DEFAULTS={animation:!0,modalSize:"sm",selectTemplate:'<div class="selectWrap clearfix"><span class="select-content"></span><a href="#" class="open-options clickable"><span class="icon icon-list">&#9776;</span></a></div>',selectOptionTemplate:'<span class="addedOption" ><span class="text"></span><span class="clickable removeOption"><span class="icon icon-remove" aria-hidden="true">&#9747;</span></span></span>',modalTemplate:'<div class="select modal in" aria-hidden="false"><div class="modal-dialog"><div class="modal-content"><div class="modal-header"><div><h5 class="modal-title"></h5><div class="help-block"></div></div><span class="float-right clickable close" aria-hidden="true">&#9747;</span></div><div class="modal-body"></div></div></div></div>',modalOptionTemplate:'<div class="option clickable"><span class="option-text"></span><span class="option-tick"><span class="icon icon-ok" aria-hidden="true">&#x2713;</span></span></div>',title:"Select Options"},p.prototype.init=function(t,e){var i=l(t);if(this.$element=i.clone(!0,!0),this.enabled=this.isEnabled(),this.multiple=this.isMultiple(),this.options=this.getOptions(e),!this.$element.is("select"))throw new Error("Popup MultiSelect only possible in select.");this.replaceDefaultSelect(i),this.$selectOptions=this.extractSelectOptions()},p.prototype.isEnabled=function(){return!this.$element.prop("disabled")},p.prototype.isMultiple=function(){return this.$element.prop("multiple")},p.prototype.hasSelectOptions=function(){return 0<this.$selectOptions.length},p.prototype.extractSelectOptions=function(){var n=[],o=this.getOptionConfig(),s=this;return l.each(this.$element.find("option"),function(t,e){var i=new p.Option(e,o);n.push(i),i.isSelected()&&s._optionSelected(i)}),n},p.prototype.replaceDefaultSelect=function(t){var e=this.getMultiSelect();t.replaceWith(e),this.$element.css({visibility:"hidden",height:"0px",width:"0px"}),e.append(this.$element),this.postProcess(),this.initMultiSelect()},p.prototype.initMultiSelect=function(){var e=this;this.getMultiSelectOpen().on("click",function(t){t.preventDefault(),e.show()})},p.prototype.getDefaults=function(){return p.DEFAULTS},p.prototype.getOptions=function(t){return t=l.extend({},this.getDefaults(),this.$element.data(),t),this.multiple||(t.maxSelectionAllowed=1),t},p.prototype.getOptionConfig=function(t){return{modalOptionTemplate:this.options.modalOptionTemplate,selectOptionTemplate:this.options.selectOptionTemplate}},p.prototype.getUID=function(t){for(;t+=~~(1e6*Math.random()),document.getElementById(t););return t},p.prototype.getMultiSelect=function(){if(!this.$multiSelect){this.$multiSelect=l(this.options.selectTemplate),this.enabled||this.$multiSelect.addClass("disabled");for(var t=this.$element.prop("class").split(" "),e=0;e<t.length;e++)this.$multiSelect.addClass(t[e])}var i=this.getUID(this.$element.attr("id")||"selectContainer");return this.$multiSelect.attr("id",i),this.$element.attr("aria-describedby",i),this.$multiSelect},p.prototype.getSelectOpenIcon=function(){return this.getMultiSelectOpen().find("span.icon")},p.prototype.getMultiSelectOpen=function(){return this.$openOptions||(this.$openOptions=this.$multiSelect.find(".open-options"))},p.prototype.getMultiSelectContent=function(){return this.$selectContent||(this.$selectContent=this.$multiSelect.find(".select-content"))},p.prototype.getSelected=function(){return this.getMultiSelectContent().children()},p.prototype.getModal=function(){return this.$modal||(this.$modal=l(this.options.modalTemplate),this.getModalHelpBlock(this.$modal).html(this.getModalHelpTextContent()),this.getModalTitleBlock(this.$modal).html(this.getModalTitle()),this.getModalBody(this.$modal).html(this.getModalBodyContent()),this.getModalDialog(this.$modal).addClass(this.getModalSizeClass()),this.initModal(this.$modal)),this.$modal},p.prototype.getModalClose=function(t){return t.find(".close")},p.prototype.getModalHelpBlock=function(t){return(t=t||this.getModal()).find(".help-block")},p.prototype.getModalTitleBlock=function(t){return(t=t||this.getModal()).find(".modal-title")},p.prototype.getModalBody=function(t){return(t=t||this.getModal()).find(".modal-body")},p.prototype.getModalDialog=function(t){return(t=t||this.getModal()).find(".modal-dialog")},p.prototype.getModalHelpTextContent=function(t,e){var i="",n=this.getSelected().length,o=this.options.maxSelectionAllowed,s=o-n;if(!(o<1))return 0===n&&0<s?i="Select "+s:0<s?i="Select "+s+" more.":0==s&&(i="Done."),i},p.prototype.getModalTitle=function(){return this.options.title},p.prototype.getModalSizeClass=function(){return"modal-"+this.options.modalSize},p.prototype.getModalBodyContent=function(){var n=this,o=[];return l.each(this.$selectOptions,function(t,e){var i=e.createModalOption();i.on("click",function(){var t=l(this),e=t.data("multiselect.option");t.hasClass("selected")?n.optionDeSelected(e):n.optionSelected(e)}),o.push(i)}),o},p.prototype.postProcess=function(){var t=this.$multiSelect.height(),e=this.$multiSelect.outerWidth(),i=parseInt(this.$multiSelect.css("padding-right")),n=parseInt(this.$multiSelect.css("padding-left")),o=this.getMultiSelectContent(),s=this.getMultiSelectOpen(),l=this.getSelectOpenIcon(),p=parseInt(l.css("font-size")),a=(t-p)/2,d=e-i-n-p;o.css({width:d}),s.css({height:p,"margin-top":a,"margin-bottom":a,right:i})},p.prototype.updateHelpText=function(t,e){return this.getModalHelpBlock(this.getModal()).html(this.getModalHelpTextContent(t,e)),!0},p.prototype.initModal=function(t){var i=this;this.getModalClose(t).on("click",function(){i.hide()}),t.on("hide.bs.modal",function(t){var e=l.Event("hide.bs."+i.type);i.$element.trigger(e),e.isDefaultPrevented()&&t.preventDefault()}),t.on("hidden.bs.modal",function(t){i.modalShown=!1;var e=l.Event("hidden.bs."+i.type);i.$element.trigger(e),i.cleanModal()})},p.prototype.show=function(){var t=l.Event("show.bs."+this.type);if(this.hasSelectOptions()&&this.enabled){this.$element.trigger(t);var e=l.contains(this.$multiSelect[0].ownerDocument.documentElement,this.$multiSelect[0]);if(t.isDefaultPrevented()||!e)return;var i=this.getModal(),n=this.getUID(this.type);this.appendModal(),i.attr("id",n),this.$multiSelect.attr("aria-describedby",n),this.options.animation&&i.addClass("fade"),l("body").prepend(i);var o=this;i.on("shown.bs.modal",function(){o.modalShown=!0;var t=l.Event("shown.bs."+o.type);o.$element.trigger(t)}),i.modal("show")}},p.prototype.hide=function(){this.getModal().modal("hide")},p.prototype.cleanModal=function(){this.$multiSelect.removeAttr("aria-describedby"),this.$modal.remove(),this.$modal=null},p.prototype.appendModal=function(){l("body").prepend(this.$modal)},p.prototype.addOption=function(t){var e=l("<option></option>",t),i=new p.Option(e,this.getOptionConfig()),n=null;n=l.Event("addingoption.bs."+this.type),this.$element.trigger(n,i),n.isDefaultPrevented()||(this.$element.append(e),this.$selectOptions.push(i),n=l.Event("optionadded.bs."+this.type),this.$element.trigger(n,i),e.prop("selected")&&this.optionSelected(i),this.modalShown&&this.getModalBody().html(this.getModalBodyContent()))},p.prototype.selectOption=function(t){var e=this.$element.find("option[value="+t+"]").data("multiselect.option");this.optionSelected(e)},p.prototype.deselectOption=function(t){var e=this.$element.find("option[value="+t+"]").data("multiselect.option");this.optionDeSelected(e)},p.prototype.enable=function(){if(!this.enabled){this.$multiSelect.removeClass("disabled"),this.$element.prop("disabled",!1),this.enabled=!0;var t=l.Event("enabled.bs."+this.type);this.$element.trigger(t)}},p.prototype.disable=function(){if(this.enabled){this.$multiSelect.addClass("disabled"),this.$element.prop("disabled",!0),this.enabled=!1;var t=l.Event("disabled.bs."+this.type);this.$element.trigger(t)}},p.prototype.optionSelected=function(t){var e=null;if(this.options.maxSelectionAllowed==this.getSelected().length)return e=l.Event("maxselected.bs."+this.type),this.$element.trigger(e,t),!0;e=l.Event("selected.bs."+this.type),this.$element.trigger(e,t),e.isDefaultPrevented()||(t.selected(),this._optionSelected(t),e=l.Event("selectiondone.bs."+this.type),this.$element.trigger(e,t),this.updateHelpText(t,e),this.postProcess())},p.prototype._optionSelected=function(t){var e=this,i=t.getContent();i.find(".removeOption").on("click",function(){e.optionDeSelected(t)}),this.getMultiSelectContent().append(i)},p.prototype.optionDeSelected=function(t){var e=l.Event("deselected.bs."+this.type);this.$element.trigger(e,t),e.isDefaultPrevented()||(t.deselected(),t.getContent().remove(),e=l.Event("deselectiondone.bs."+this.type),this.$element.trigger(e,t),this.updateHelpText(t,e),this.postProcess())},(p.Option=function(t,e){this.options=null,this.enabled=null,this.timeout=null,this.$element=null,this.type="multiselect.option",this.init(t,e)}).DEFAULTS={},p.Option.prototype.init=function(t,e){if(this.$element=l(t),this.enabled=this.isEnabled(),this.options=this.getOptions(e),!this.$element.is("option"))throw new Error("Popup MultiSelect Option only possible on option element.");this.$element.data(this.type,this),this.tip()},p.Option.prototype.tip=function(){this.$tip||(this.$tip=l(this.options.modalOptionTemplate),this.$tip.find(".option-text").html(this.$element.text()),this.enabled||this.$tip.addClass("disabled"),this.isSelected()&&this.selected())},p.Option.prototype.getDefaults=function(){return p.Option.DEFAULTS},p.Option.prototype.getOptions=function(t){return t=l.extend({},this.getDefaults(),this.$element.data(),t)},p.Option.prototype.isEnabled=function(){return!this.$element.prop("disabled")},p.Option.prototype.createModalOption=function(){return this.$tip.data(this.type,this),this.$tip},p.Option.prototype.isSelected=function(){return this.$element.prop("selected")},p.Option.prototype.selected=function(){this.$element.attr("selected","selected"),this.$tip.addClass("selected")},p.Option.prototype.deselected=function(){this.$element.removeAttr("selected"),this.$tip.removeClass("selected")},p.Option.prototype.getContent=function(){return this.$content||(this.$content=l(this.options.selectOptionTemplate),this.$content.find(".text").html(this.$element.html()),this.enabled||this.$content.addClass("disabled"),this.$content.data(this.type,this)),this.$content};var t=l.fn.multiselect;l.fn.multiselect=function(n){var o=Array.prototype.slice.call(arguments);return o.shift(),this.each(function(){var t=l(this),e=t.data("bs.multiselect"),i="object"==typeof n&&n;!e&&/destroy|hide/.test(n)||(e||(t=(e=new p(this,i)).$element).data("bs.multiselect",e),"string"==typeof n&&e[n].apply(e,o))})},l.fn.multiselect.Constructor=p,l.fn.multiselect.noConflict=function(){return l.fn.multiselect=t,this}}(jQuery);