# Vantl - Vanilla Timeline

Vanilla Timeline (Vantl) is a lightweight, responsive timeline library created with vanilla Javascript for creating beautiful horizontal and vertical timelines with zero dependencies. Inspired by [timeline](https://github.com/squarechip/timeline) originally created by [squarechip](https://github.com/squarechip) in 2018. You can load your timeline data via a variety of methods and, you can include multiple timelines on a single page.

## Features

- ✨ **Zero dependencies** - Pure vanilla JavaScript (jQuery optional)
- 📱 **Fully responsive** - Auto-switches between horizontal/vertical layouts
- 🎨 **Customizable colors** - Theme nodes, lines, and navigation
- 🖼️ **Rich content** - Support for images, HTML, and modal popups
- 🔗 **Deep linking** - Link directly to specific timeline nodes via URL
- 📦 **Multiple layouts** - Vertical scroll or horizontal carousel modes
- 💾 **Smart caching** - LocalStorage caching for JSON data
- 🚀 **Auto-init** - Just add a data attribute to load from JSON
- 📏 **Small footprint** - Minified and tree-shakeable

## Online Demo: 
- [Quick Start](https://kendawson.online/vantl/demo/quick-start/)
- [Example Horizontal Timeline](https://kendawson.online/vantl/demo/json/horizontal/)
- [Example Vertical Timeline](https://kendawson.online/vantl/demo/json/vertical/)
---

### Screenshot

<img src="demo/assets/img/timeline-screenshot.png"/>

<br/>

# Getting Started:

Load stylesheet and Javascript functions to your document via CDN links:

````html
<!DOCTYPE html>
<html>
<head>
  <!-- load stylesheet -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@kendawson-online/vantl@latest/dist/timeline.min.css">
</head>
<body>
   
  <!-- your timeline will go here --> 
  
  <!-- load functions -->
  <script src="https://cdn.jsdelivr.net/npm/@kendawson-online/vantl@latest/dist/timeline.min.js"></script>
</body>
</html>
````
<br/>

### 1️⃣ CREATE A TIMELINE USING BASIC HTML

<br/>

Add some timeline node data in HTML. If you want your timeline to be oriented horizontally, set `data-mode="horizontal"` on the parent element (see code below). If you omit this setting, the timeline will be oriented vertically by default.

````html
<!-- your timeline --> 
<div class="timeline" data-mode="horizontal">
  <div class="timeline__wrap">
    <div class="timeline__items">
        <div class="timeline__item">
            <div class="timeline__content">
                <h5>Jan. 1, 2000</h5                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           